/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Hashtable;
import java.util.Vector;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.ActorContext;
import org.coos.javaframe.ActorSpec;
import org.coos.javaframe.ApplicationSpec;
import org.coos.javaframe.SchedulerData;
import org.coos.javaframe.State;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.TestScheduler;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

public class StateMachineTester
implements AFConstants {
    StateMachine sm;
    TestScheduler scheduler;
    SchedulerData schedulerData;
    ActorAddress senderRole = new ActorAddress("test", "Tester");
    ActorAddress receiver;

    public StateMachineTester(StateMachine stateMachine, ActorAddress receiver, ApplicationSpec appSpec) {
        this.sm = stateMachine;
        this.sm.setTesting(true);
        this.receiver = receiver;
        this.sm.setMyActorId(receiver.getActorID());
        this.sm.setMyActorType(receiver.getActorType());
        this.schedulerData = new SchedulerData();
        this.scheduler = new TestScheduler(this.schedulerData);
        this.schedulerData.setApplicationSpec(appSpec);
        this.sm.setScheduler(this.scheduler);
        this.sm.init();
    }

    public boolean containsWaring() {
        Vector v = this.sm.getTrace().getWarnings();
        return v == null || v.isEmpty();
    }

    public boolean containsError() {
        Vector v = this.sm.getTrace().getErrors();
        return v == null || v.isEmpty();
    }

    public StateMachine getStateMacine() {
        return this.sm;
    }

    public void setAppSpec(ApplicationSpec appSpec) {
        this.schedulerData.setApplicationSpec(appSpec);
    }

    public void processMessage(ActorMsg message, String portName) {
        ActorAddress receiver = this.sm.getMyActorAddress();
        receiver.setActorPort(portName);
        message.setReceiverRole(receiver);
        if (message.getSenderRole() == null) {
            message.setSenderRole(this.senderRole);
        }
        this.sm.processMessage(message);
    }

    public void processMessage(String message) {
        this.processMessage(new AFPropertyMsg(message));
    }

    public void processMessage(ActorMsg am) {
        if (am == null) {
            return;
        }
        if (am.getReceiverRole() == null) {
            am.setReceiverRole(this.sm.getMyActorAddress());
        }
        if (am.getSenderRole() == null) {
            am.setSenderRole(this.senderRole);
        }
        this.sm.processMessage(am);
    }

    public String getNextState() {
        return this.sm.getTrace().getNewState();
    }

    public String getCurrentState() {
        return this.sm.getCurrentState().stateName();
    }

    public boolean equalsState(String stateNasme) {
        return this.sm.getCurrentState().stateName().equals(stateNasme);
    }

    public boolean containsOutputMsg(String msgId) {
        Vector v = this.sm.getTrace().getOutputSignals();
        for (int i = 0; i < v.size(); ++i) {
            ActorMsg msg = (ActorMsg)v.elementAt(i);
            if (!msg.getSignalName().equals(msgId)) continue;
            return true;
        }
        return false;
    }

    public int countOutputMsg() {
        return this.sm.getTrace().getOutputSignals().size();
    }

    public int countsOutputMsg(String msgId) {
        int no = 0;
        Vector v = this.sm.getTrace().getOutputSignals();
        for (int i = 0; i < v.size(); ++i) {
            ActorMsg msg = (ActorMsg)v.elementAt(i);
            if (!msg.getSignalName().equals(msgId)) continue;
            ++no;
        }
        return no;
    }

    public ActorMsg getOutputMsg(int index) {
        if (index < this.countOutputMsg()) {
            return (ActorMsg)this.sm.getTrace().getOutputSignals().elementAt(index);
        }
        return null;
    }

    public ActorMsg getOutputMsg(String msgId) {
        Vector v = this.sm.getTrace().getOutputSignals();
        for (int i = 0; i < v.size(); ++i) {
            ActorMsg msg = (ActorMsg)v.elementAt(i);
            if (!msg.getSignalName().equals(msgId)) continue;
            return msg;
        }
        return null;
    }

    public boolean containsTimerMsg(String timerId) {
        Hashtable timers = this.sm.getActiveTimers();
        return timers != null && timers.get(timerId) != null;
    }

    public void setPrintoutDisabled(boolean disabled) {
        this.sm.getTrace().setOutputDisabled(disabled);
        this.scheduler.setPrinting(!disabled);
    }

    public void sendTimer(String timerId) {
        AFPropertyMsg pm = new AFPropertyMsg("TimerMsg", true);
        pm.setProperty("timerId", timerId);
        this.processMessage(pm);
    }

    public String createActor() {
        AFPropertyMsg rrm = new AFPropertyMsg("RoleRequestMsg", true);
        rrm.setProperty("roleId", this.sm.getID());
        rrm.setProperty("roleType", this.sm.getType());
        rrm.setSenderRole(this.senderRole);
        AFPropertyMsg pm = new AFPropertyMsg("RolePlayMsg", true);
        pm.setProperty("rrm", rrm);
        pm.setProperty("ports", new Vector());
        this.processMessage(pm);
        return this.getCurrentState();
    }

    public void sendRoleRequestMsg(String roleId, String roleType) {
        AFPropertyMsg pm = new AFPropertyMsg("RoleRequestMsg", true);
        pm.setProperty("roleId", roleId);
        pm.setProperty("roleType", roleType);
        this.processMessage(pm);
    }

    public void sendRolePlayMsg(String[] portNames) {
        this.sendRolePlayMsg(this.sm.getID(), this.sm.getType(), this.getVector(portNames));
    }

    public void sendRolePlayMsg(String roleId, String roleType, Vector ports) {
        AFPropertyMsg rrm = new AFPropertyMsg("RoleRequestMsg");
        rrm.setProperty("roleId", roleId);
        rrm.setProperty("roleType", roleType);
        rrm.setSenderRole(this.senderRole);
        AFPropertyMsg pm = new AFPropertyMsg("RolePlayMsg", true);
        pm.setProperty("rrm", rrm);
        pm.setProperty("ports", ports);
        pm.setProperty("connectors", this.sm.actorSpec.getConnectorDesc(roleType, null));
        this.processMessage(pm);
    }

    public void sendRoleCreateMsg(String[] portNames) {
        Vector v = this.getVector(portNames);
        this.sendRoleCreateMsg(this.sm.getType(), v);
    }

    public void sendRoleCreateMsg(String enclosingType, Vector ports) {
        AFPropertyMsg pm = new AFPropertyMsg("RoleCreateMsg", true);
        pm.setReceiverRole(this.receiver);
        pm.setProperty("ports", ports);
        pm.setProperty("connectors", this.sm.actorSpec.getConnectorDesc(enclosingType, null));
        this.processMessage(pm);
    }

    public void sendRoleCreateMsg(String enclosingType) {
        AFPropertyMsg pm = new AFPropertyMsg("RoleCreateMsg", true);
        pm.setReceiverRole(this.receiver);
        ActorSpec enclosingActorSpec = this.schedulerData.getApplicationSpec().getActorSpec(enclosingType);
        pm.setProperty("ports", enclosingActorSpec.getConnectorDesc(this.sm.getType(), null));
        pm.setProperty("connectors", enclosingActorSpec.getConnectorDesc(this.sm.getType(), null));
        this.processMessage(pm);
    }

    private Vector getVector(String[] strings) {
        if (strings == null) {
            return new Vector();
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < strings.length; ++i) {
            v.addElement(strings[i]);
        }
        return v;
    }

    public boolean setNextState(String stateName) {
        State st = this.sm.getCompositeState().findCurrentState(stateName);
        if (st != null) {
            this.sm.setNextState(st);
            return true;
        }
        return false;
    }

    public ActorContext getActorContext() {
        return this.sm.context;
    }

    public void addActorSpec(ActorSpec actorSpec) {
        this.sm.getApplicationSpec().addActorSpec(actorSpec);
        this.sm.actorSpec = this.sm.getApplicationSpec().getClonedActorSpec(actorSpec.getActorType());
    }
}

