/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import java.util.Vector;

/**
 * @author Geir Melby, Tellu AS
 */
public class SchedulerSpec {
    private Vector actorTypes = new Vector();
    private int threads = 1;
    private String id;
    private String className;

    public SchedulerSpec() {
    }

    public SchedulerSpec(String id) {
        this.id = id;
    }

    public Vector getActorTypes() {
        return actorTypes;
    }

    public String getActorType(String actor) {
        for (int i = 0; i < actorTypes.size(); i++) {
            String s = (String) actorTypes.elementAt(i);
            if (s.equals(actor)) {
                return s;
            }
        }

        return null;
    }

    public int getThreads() {
        return threads;
    }

    public String getId() {
        return id;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof SchedulerSpec)) {
            return false;
        }

        SchedulerSpec that = (SchedulerSpec) o;

        if ((id != null) ? (!id.equals(that.id)) : (that.id != null)) {
            return false;
        }

        return true;
    }

    public void addActorType(String actorType) {
        actorTypes.addElement(actorType);
    }

    public String getClassName() {
        if (className == null) {
            if (threads > 1) {
                className = ("org.coos.javaframe.ThreadPooledScheduler");
            } else {
                className = ("org.coos.javaframe.SchedulerImpl");
            }
        }
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Scheduler id: <" + id + "> Threads: <" + threads + "> Class name: <" + className + ">");
        sb.append("\n       Actors: ");
        for (int i = 0; i < actorTypes.size(); i++) {
            String s = (String) actorTypes.elementAt(i);
            sb.append("<" + s + ">, ");
        }
        return sb.toString();
    }
}
