/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

/**
 * 
 * @author Geir Melby, Tellu AS
 * 
 * 
 */
public class TraceConstants {
	public static final int ctSetCategory = 0x1;
	/* Set trace level */
	public static final int ctSetLevel = 0x2;

	/*
	 * Trace category values to be set - if relevant.
	 * 
	 * /* All trace categories off
	 */
	public static final int tcOff = 0x0;
	/* All trace categories on */
	public static final int tcAllOn = ~0x0;
	/* Trace task execusion */
	public static final int tcTask = 0x1;
	/* Different kind of Actor frame tracing */
	public static final int tcSystem = 0x2;
	/* Trace state transition */
	public static final int tcTransition = 0x4;
	/* Trace message sending */
	public static final int tcSendMsg = 0x8;
	/* Other trace output generated by Actor Frame framework */
	public static final int tcFramework = 0x10;
	/* Added by Ronnie Nessa. Trace creation of actors */
	public static final int tcTraceDiagram = 0x20;
	/* Categories that can be applied by the user */
	public static final int tcUser1 = 0x100;
	public static final int tcUser2 = 0x200;
	public static final int tcUser3 = 0x300;
	public static final int tcUser4 = 0x400;

	/*
	 * For debugging, includes this and all other levels. Normally used by
	 * applications
	 */
	public static final int tlDebug = 1;
	/*
	 * For information, includes this and all higher levels. Lowest level used
	 * by framework
	 */
	public static final int tlInfo = 2;
	/* Give warnings, includes this and all higher levels */
	public static final int tlWarn = 3;
	/* Give error reports, includes this and all higher levels */
	public static final int tlError = 4;
	/* Give warnings, is the highest levels. The application should terminate */
	public static final int tlFatal = 5;

	public static final String Off = "off";
	public static final String AllOn = "allOn";
	public static final String Task = "task";
	public static final String System = "System";
	public static final String Transition = "transition";
	public static final String SendMsg = "SendMsg";
	public static final String FrameWork = "FrameWork";
	/* Added by Ronnie Nessa */
	public static final String TraceDiagram = "TraceDiagram";
	public static final String Debug = "Debug";
	public static final String Info = "Info";
	public static final String Warn = "Warn";
	public static final String Error = "Error";
	public static final String Fatal = "Fatal";
	public static final String SetCategory = "SetCategory";
	public static final String SetLevel = "SetLevel";

	public static int getCommandType(String commandType) {
		int value = 0;
		if (commandType.equals(TraceConstants.SetLevel))
			value = TraceConstants.ctSetLevel;
		if (commandType.equals(TraceConstants.SetCategory))
			value = TraceConstants.ctSetCategory;
		return value;
	}

	public static int getTraceCategories(String traceCategories) {
		int value = -1;
		if (traceCategories.equalsIgnoreCase(TraceConstants.Off))
			value = TraceConstants.tcOff;
		else if (traceCategories.equalsIgnoreCase(TraceConstants.AllOn))
			value = TraceConstants.tcAllOn;
		else if (traceCategories.equalsIgnoreCase(TraceConstants.System))
			value = TraceConstants.tcSystem;
		else if (traceCategories.equalsIgnoreCase(TraceConstants.Transition))
			value = TraceConstants.tcTransition;
		else if (traceCategories.equalsIgnoreCase(TraceConstants.FrameWork))
			value = TraceConstants.tcFramework;
		else if (traceCategories.equalsIgnoreCase(TraceConstants.SendMsg))
			value = TraceConstants.tcSendMsg;
		/* Added by Ronnie Nessa */
		else if (traceCategories.equalsIgnoreCase(TraceConstants.TraceDiagram))
			value = TraceConstants.tcTraceDiagram;
		return value;
	}

	public static int getTraceLevel(String traceLevel) {
		int value = 1;
		if (traceLevel.equalsIgnoreCase(TraceConstants.Debug))
			value = TraceConstants.tlDebug;
		if (traceLevel.equalsIgnoreCase(TraceConstants.Info))
			value = TraceConstants.tlInfo;
		if (traceLevel.equalsIgnoreCase(TraceConstants.Fatal))
			value = TraceConstants.tlFatal;
		if (traceLevel.equalsIgnoreCase(TraceConstants.Error))
			value = TraceConstants.tlError;
		if (traceLevel.equalsIgnoreCase(TraceConstants.Warn))
			value = TraceConstants.tlWarn;

		return value;
	}

	public static String getTraceCategories(int traceCategories) {
		String value = "";
		if (traceCategories == TraceConstants.tcOff)
			return TraceConstants.Off;
		if (traceCategories == TraceConstants.tcAllOn)
			return TraceConstants.AllOn;
		if ((traceCategories & TraceConstants.tcSystem) != 0)
			return TraceConstants.System;
		if ((traceCategories & TraceConstants.tcTransition) != 0)
			return TraceConstants.Transition;
		if ((traceCategories & TraceConstants.tcSendMsg) != 0)
			return TraceConstants.SendMsg;
		if ((traceCategories & TraceConstants.tcFramework) != 0)
			return TraceConstants.FrameWork;
		/* Added by Ronnie Nessa */
		if ((traceCategories & TraceConstants.tcTraceDiagram) != 0)
			return TraceConstants.TraceDiagram;
		return value;
	}

	public static String getCommandType(int commandType) {
		String value = "";
		if (commandType == TraceConstants.ctSetLevel)
			value = TraceConstants.SetLevel;
		if (commandType == TraceConstants.ctSetCategory)
			value = TraceConstants.SetCategory;
		return value;
	}

	public static String getTraceLevel(int traceLevel) {
		String value = "";
		if (traceLevel == TraceConstants.tlDebug)
			value = TraceConstants.Debug;
		if (traceLevel == TraceConstants.tlInfo)
			value = TraceConstants.Info;
		if (traceLevel == TraceConstants.tlFatal)
			value = TraceConstants.Fatal;
		if (traceLevel == TraceConstants.tlError)
			value = TraceConstants.Error;
		if (traceLevel == TraceConstants.tlWarn)
			value = TraceConstants.Warn;
		return value;
	}
}
