/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe.messages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.PropertyException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AFPropertyMsgTest
extends TestCase {
    AFPropertyMsg msg0;
    AFPropertyMsg msg1;
    static String KEY = "key";

    @Before
    public void setUp() throws Exception {
        this.msg0 = new AFPropertyMsg("testMsg");
    }

    @After
    public void tearDown() throws Exception {
        this.msg0 = null;
        this.msg1 = null;
    }

    @Test
    public void testGetIntFromLong() {
        long value = 10L;
        this.msg0.setLong(KEY, value);
        AFPropertyMsgTest.assertEquals((long)value, (long)this.msg0.getInt(KEY));
        AFPropertyMsgTest.assertEquals((long)value, (long)this.msg0.getInt(KEY, 12345));
    }

    @Test
    public void testGetLongFromInt() {
        int value = 10;
        this.msg0.setLong(KEY, (long)value);
        AFPropertyMsgTest.assertEquals((long)value, (long)this.msg0.getLong(KEY));
        AFPropertyMsgTest.assertEquals((long)value, (long)this.msg0.getLong(KEY, 12345L));
    }

    @Test(expected=PropertyException.class)
    public void testGetIntFromExtraLong() {
        long value = 0x80000009L;
        this.msg0.setLong(KEY, value);
        this.msg0.getInt(KEY);
    }

    @Test(expected=ClassCastException.class)
    public void testGetIntFromDouble() {
        double value = 1.0;
        this.msg0.setProperty(KEY, (Object)value);
        this.msg0.getInt(KEY);
    }

    @Test
    public void getFloatFromDouble() {
        double value = 3.4028234663852886E38;
        this.msg0.setProperty(KEY, (Object)value);
        AFPropertyMsgTest.assertEquals((double)value, (double)this.msg0.getFloat(KEY), (double)1.0E-5);
    }

    @Test
    public void getFloatFromInteger() {
        this.msg0.setInt(KEY, 1);
        AFPropertyMsgTest.assertEquals((double)1.0, (double)this.msg0.getFloat(KEY), (double)1.0E-5);
    }

    @Test
    public void getFloatFromLong() {
        this.msg0.setLong(KEY, 1L);
        AFPropertyMsgTest.assertEquals((double)1.0, (double)this.msg0.getFloat(KEY), (double)1.0E-5);
    }

    @Test
    public void getDoubleFromInteger() {
        this.msg0.setInt(KEY, 1);
        AFPropertyMsgTest.assertEquals((double)1.0, (double)this.msg0.getDouble(KEY), (double)1.0E-5);
    }

    @Test
    public void getDoubleFromLong() {
        this.msg0.setLong(KEY, 1L);
        AFPropertyMsgTest.assertEquals((double)1.0, (double)this.msg0.getDouble(KEY), (double)1.0E-5);
    }

    @Test
    public void getFloatFromSmallDouble() {
        double value = 1.4012984643248171E-46;
        AFPropertyMsgTest.assertTrue((value < (double)1.4E-45f ? 1 : 0) != 0);
        AFPropertyMsgTest.assertTrue((value > 0.0 ? 1 : 0) != 0);
        this.msg0.setProperty(KEY, (Object)value);
        AFPropertyMsgTest.assertEquals((double)value, (double)this.msg0.getFloat(KEY), (double)1.0E-5);
    }

    @Test
    public void getFloatFromFloatMaxValueAsDouble() {
        double value = 3.4028234663852886E38;
        this.msg0.setProperty(KEY, (Object)value);
        AFPropertyMsgTest.assertEquals((double)value, (double)this.msg0.getFloat(KEY), (double)1.0E-5);
    }

    @Test
    public void getFloatFromFloatNegMaxValueAsDouble() {
        double value = -3.4028234663852886E38;
        this.msg0.setProperty(KEY, (Object)value);
        AFPropertyMsgTest.assertEquals((double)value, (double)this.msg0.getFloat(KEY), (double)1.0E-5);
    }

    @Test(expected=PropertyException.class)
    public void getFloatFromLargeDouble() {
        double value = 3.502823466385288E38;
        AFPropertyMsgTest.assertTrue((value > 3.4028234663852886E38 ? 1 : 0) != 0);
        this.msg0.setProperty("key", (Object)value);
        this.msg0.getFloat("key");
    }

    @Test
    public void testPropertyDoubleArray() throws Exception {
        double[] d = new double[]{1.12345, 2.23456};
        this.msg0.setProperty(KEY, (Object)d);
        double[] e = (double[])this.msg0.getProperty(KEY);
        AFPropertyMsgTest.assertEquals((Object)d[0], (Object)e[0]);
        AFPropertyMsgTest.assertEquals((Object)d[1], (Object)e[1]);
        byte[] bytes = this.msg0.serialize();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        this.msg1 = new AFPropertyMsg((InputStream)is, null);
        ((InputStream)is).close();
        e = (double[])this.msg1.getProperty(KEY);
        AFPropertyMsgTest.assertEquals((Object)d[0], (Object)e[0]);
        AFPropertyMsgTest.assertEquals((Object)d[1], (Object)e[1]);
    }

    @Test(expected=IOException.class)
    public void testPropertyBoxedDoubleArray() throws Exception {
        Double[] d = new Double[]{1.12345, 2.23456};
        this.msg0.setProperty(KEY, (Object)d);
        Double[] e = (Double[])this.msg0.getProperty(KEY);
        AFPropertyMsgTest.assertEquals((Object)d[0], (Object)e[0]);
        AFPropertyMsgTest.assertEquals((Object)d[1], (Object)e[1]);
        byte[] bytes = this.msg0.serialize();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        this.msg1 = new AFPropertyMsg((InputStream)is, null);
        ((InputStream)is).close();
        e = (Double[])this.msg1.getProperty(KEY);
        AFPropertyMsgTest.assertEquals((Object)d[0], (Object)e[0]);
        AFPropertyMsgTest.assertEquals((Object)d[1], (Object)e[1]);
    }
}

