/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.messages.ActorAddressHelper;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.ArrayHelper;
import org.coos.util.serialize.StringHelper;

public class PartSpec
implements AFSerializer {
    public String roleType;
    protected String[] roleNames;
    protected boolean credentialsRequired;
    protected boolean visible;
    protected int set = 0;
    protected int low = 1;
    protected int high = 1;
    protected int level = 4;
    protected ActorAddress actorDomain;
    protected Hashtable portConnectors;
    protected String setId;
    private int traceLev = 3;
    private static String SET_ID = "set";
    protected String bind;

    public PartSpec() {
    }

    public PartSpec(String roleName, String roleType) {
        this.roleType = roleType;
        this.low = 1;
        this.high = 1;
        this.roleNames = new String[this.low];
        this.roleNames[0] = roleName;
        this.actorDomain = null;
        this.setId = SET_ID;
    }

    public PartSpec(String roleName, String roleType, int low, int high) {
        this.roleType = roleType;
        this.low = low;
        this.high = high;
        this.roleNames = low == 0 ? new String[1] : new String[this.low];
        this.roleNames[0] = roleName;
        this.actorDomain = null;
        this.setId = SET_ID;
    }

    public PartSpec(String[] roleNames, String roleType, int low, int high) {
        this.roleType = roleType;
        this.low = low;
        this.high = high;
        this.roleNames = roleNames;
        this.actorDomain = null;
        this.setId = SET_ID;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public String getBind() {
        return this.bind;
    }

    public void setBind(String bind) {
        this.bind = bind;
    }

    public int getTraceLev() {
        return this.traceLev;
    }

    public void setTraceLev(int traceLev) {
        this.traceLev = traceLev;
    }

    public void setRoleNames(String[] roleNames) {
        this.roleNames = roleNames;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public ActorAddress getActorDomain() {
        return this.actorDomain;
    }

    public void setActorDomain(ActorAddress actorDomain) {
        this.actorDomain = actorDomain;
    }

    public boolean isCredentialsRequired() {
        return this.credentialsRequired;
    }

    public void setCredentialsRequired(boolean credentialsRequired) {
        this.credentialsRequired = credentialsRequired;
    }

    public boolean exeedsCardinality(int value) {
        return value < this.high;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public String getRoleType() {
        return this.roleType;
    }

    public String[] getRoleNames() {
        if (this.roleNames == null) {
            this.roleNames = new String[0];
        }
        return this.roleNames;
    }

    public void setSetNo(int i) {
        this.set = i;
    }

    public int getSetNo() {
        return this.set;
    }

    public String getSetId() {
        return this.setId;
    }

    public void setSetId(String setId) {
        this.setId = setId;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartSpec)) {
            return false;
        }
        PartSpec part = (PartSpec)o;
        return !(this.roleType != null ? !this.roleType.equals(part.roleType) : part.roleType != null);
    }

    public int hashCode() {
        return this.roleType != null ? this.roleType.hashCode() : 0;
    }

    public String toString() {
        Vector<String> inst = new Vector<String>();
        if (this.roleNames != null) {
            for (int i = 0; i < this.roleNames.length; ++i) {
                inst.addElement(this.roleNames[i]);
            }
        }
        String s = " Type: " + this.roleType + " Visible: " + this.isVisible() + " Min: " + this.low + " Max: " + this.high + " Instances: " + inst.toString();
        if (this.actorDomain != null) {
            s = s + " ActorDomain: " + this.actorDomain;
        }
        return s;
    }

    public String getPartDesc() {
        return this.getRoleType() + "(" + this.getLow() + "," + this.getHigh() + ")";
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.write(StringHelper.persist((String)this.roleType));
        dout.write(ArrayHelper.persist((Object)this.roleNames));
        dout.writeInt(this.low);
        dout.writeInt(this.high);
        dout.writeInt(this.level);
        dout.writeInt(this.set);
        dout.write(ActorAddressHelper.persist(this.actorDomain));
        dout.write(StringHelper.persist((String)this.setId));
        dout.writeBoolean(this.credentialsRequired);
        dout.writeBoolean(this.visible);
        dout.writeInt(this.traceLev);
        dout.flush();
        return bout.toByteArray();
    }

    public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        this.roleType = StringHelper.resurrect((DataInputStream)din);
        this.roleNames = (String[])ArrayHelper.resurrect((DataInputStream)din);
        this.low = din.readInt();
        this.high = din.readInt();
        this.level = din.readInt();
        this.set = din.readInt();
        this.actorDomain = ActorAddressHelper.resurrect(din);
        this.setId = StringHelper.resurrect((DataInputStream)din);
        this.credentialsRequired = din.readBoolean();
        this.visible = din.readBoolean();
        this.traceLev = din.readInt();
        return bin;
    }

    public boolean containsInstance(String instance) {
        if (this.roleNames == null) {
            return false;
        }
        if (instance.lastIndexOf(47) > -1) {
            instance = instance.substring(instance.lastIndexOf(47) + 1);
        }
        for (int i = 0; i < this.roleNames.length; ++i) {
            String roleName = this.roleNames[i];
            if (!roleName.equals(instance)) continue;
            return true;
        }
        return false;
    }
}

