/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Vector;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.Schedulable;
import org.coos.javaframe.SchedulableAdapter;
import org.coos.javaframe.SchedulerImpl;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.ActorMsg;

public class TstAdapter
extends SchedulableAdapter {
    Vector receivedMessages = new Vector();

    public TstAdapter(String actorAddress) {
        super(new ActorAddress(actorAddress));
    }

    public void messageHandler(ActorMsg sig) {
        this.receivedMessages.addElement(sig);
    }

    public boolean containsMessage(String messageId) {
        for (int i = 0; i < this.receivedMessages.size(); ++i) {
            ActorMsg msg = (ActorMsg)this.receivedMessages.elementAt(i);
            if (!msg.getMsgId().equals(messageId)) continue;
            return true;
        }
        return false;
    }

    public ActorMsg getMessage(String messageId) {
        for (int i = 0; i < this.receivedMessages.size(); ++i) {
            ActorMsg msg = (ActorMsg)this.receivedMessages.elementAt(i);
            if (!msg.getMsgId().equals(messageId)) continue;
            this.receivedMessages.remove(i);
            return msg;
        }
        return null;
    }

    public String waitForState(StateMachine curfsm, String name, int timeOut) {
        long timeAtStart = System.currentTimeMillis();
        Object actor = null;
        String state = null;
        if (this.sched instanceof SchedulerImpl) {
            SchedulerImpl scheduler = (SchedulerImpl)this.sched;
            state = curfsm.getCurrentState().stateName();
            while (!state.equals(name)) {
                state = curfsm.getCurrentState().stateName();
                long waitTime = System.currentTimeMillis() - timeAtStart;
                if (timeOut > 0 && waitTime > (long)timeOut) break;
                this.sleep(10);
            }
        }
        return state;
    }

    public StateMachine waitCreationOfActor(ActorAddress receiver, int timeOut) {
        long timeAtStart = System.currentTimeMillis();
        StateMachine actor = null;
        if (this.sched instanceof SchedulerImpl) {
            SchedulerImpl scheduler = (SchedulerImpl)this.sched;
            while (actor == null) {
                Schedulable o = (Schedulable)scheduler.getSchedulerData().getMySystem().get(receiver.keyWithOutPortAndRole());
                if (o != null) {
                    if (o instanceof StateMachine) {
                        actor = (StateMachine)o;
                    } else {
                        actor = null;
                        break;
                    }
                }
                long waitTime = System.currentTimeMillis() - timeAtStart;
                if (timeOut > 0 && waitTime > (long)timeOut) break;
                this.sleep(10);
            }
        }
        return actor;
    }

    public StateMachine waitCreationOfActor(String actorAddress, int timeOut) {
        return this.waitCreationOfActor(new ActorAddress(actorAddress), timeOut);
    }

    public ActorMsg waitForMessage(String messageId, long timeout) {
        long timeAtStart = System.currentTimeMillis();
        ActorMsg sig = this.getMessage(messageId);
        while (sig == null || !sig.equals(messageId)) {
            long waitTime = System.currentTimeMillis() - timeAtStart;
            if (timeout > 0L && waitTime > timeout) {
                return sig;
            }
            this.sleep(10);
            sig = this.getMessage(messageId);
        }
        if (sig != null) {
            this.receivedMessages.remove(sig);
        }
        return sig;
    }

    public void clearMessages() {
        this.receivedMessages.clear();
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean sendMessage(ActorMsg msg, ActorAddress receiver) {
        SchedulerImpl scheduler;
        Schedulable o;
        msg.setSenderRole(this.getMyActorAddress());
        msg.setReceiverRole(receiver);
        if (this.sched instanceof SchedulerImpl && (o = (Schedulable)(scheduler = (SchedulerImpl)this.sched).getSchedulerData().getMySystem().get(receiver.keyWithOutPortAndRole())) != null) {
            boolean ok = scheduler.out(msg, o);
            if (ok) {
                String str = "TestAdapter: " + this.getMyActorAddress() + " Ouutput: " + msg.messageContent();
                scheduler.getTraceObject().traceOut(1, 0, str);
            }
            return ok;
        }
        return false;
    }

    public boolean processMessage(ActorMsg sig) {
        this.receivedMessages.addElement(sig);
        return true;
    }
}

