/*
 * Decompiled with CFR 0.152.
 */
package org.coos.actorframe;

import java.util.Enumeration;
import java.util.Vector;
import org.coos.actorframe.ActorSM;
import org.coos.actorframe.Port;
import org.coos.actorframe.messages.AFConstants;
import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.CompositeState;
import org.coos.javaframe.ConnectorSpec;
import org.coos.javaframe.PartSpec;
import org.coos.javaframe.State;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

public class SuspendedCS
extends CompositeState
implements AFConstants {
    protected State waitConfirmUpdatePorts = new State("waitConfirmUpdatePorts", this);
    protected State waitConfirmUpdateParts = new State("waitConfirmUpdateParts", this);
    protected State waitConfirmCreateParts = new State("waitConfirmCreateParts", this);
    protected State waitConfirmDeleteConnectors = new State("waitConfirmDeleteConnectors", this);
    protected State waitConfirmDeletePorts = new State("waitConfirmDeletePorts", this);
    protected State waitConfirmDeleteParts = new State("waitConfirmDeleteParts", this);
    protected State waitAddedConnectors = new State("waitAddedConnectors", this);
    protected State suspended = new State("suspended", this);
    protected State suspending = new State("suspending", this);

    public SuspendedCS(String sn, CompositeState cs) {
        super(sn, cs);
    }

    public SuspendedCS() {
        super("");
    }

    public SuspendedCS(String sn) {
        super(sn);
    }

    public void enterState(StateMachine curfsm) {
        if (curfsm instanceof ActorSM) {
            ActorSM asm = (ActorSM)curfsm;
            asm.suspendedActors = curfsm.context.getChildrenRoles();
            if (asm.suspendedActors.isEmpty()) {
                curfsm.sendMessage("SuspendedMsg", asm.suspendActor);
                asm.suspendedActors = null;
                this.suspended.enterState(curfsm);
                this.entry(curfsm);
                return;
            }
            curfsm.sendMessage((ActorMsg)new AFPropertyMsg("SuspendMsg", true), asm.suspendedActors);
            this.suspending.enterState(curfsm);
            this.entry(curfsm);
            return;
        }
        this.exitState(2, curfsm);
    }

    public void execTrans(ActorMsg sig, State st, StateMachine curfsm) {
        ActorSM asm = (ActorSM)curfsm;
        if (st == this.waitConfirmDeleteConnectors) {
            if (sig.equals("CheckSpecMsg")) {
                this.performExit(curfsm);
                Vector removedConnectors = this.compareSpecs(asm.actorSpec.getConnectorDesc(), asm.newActorSpec.getConnectorDesc(), false);
                removedConnectors = asm.rewriteContextualConnectors(removedConnectors);
                for (int i = 0; i < removedConnectors.size(); ++i) {
                    ConnectorSpec connectorSpec = (ConnectorSpec)removedConnectors.elementAt(i);
                    AFPropertyMsg msg = new AFPropertyMsg("ConnectorRemoveMsg", true);
                    msg.setFrameworkMsg(true);
                    msg.setProperty("connectors", connectorSpec);
                    asm.sendMessage((ActorMsg)msg, connectorSpec.getTo());
                }
                asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                this.nextState(this.waitConfirmDeletePorts, curfsm);
                return;
            }
        } else if (st == this.waitConfirmDeletePorts) {
            if (sig.equals("CheckSpecMsg")) {
                this.performExit(curfsm);
                Vector removedPorts = this.compareSpecs(asm.actorSpec.getPortDesc(), asm.newActorSpec.getPortDesc(), false);
                Enumeration ports = removedPorts.elements();
                while (ports.hasMoreElements()) {
                    Port port = (Port)ports.nextElement();
                    port.removePort(asm);
                    asm.removePort(port);
                }
                asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                this.nextState(this.waitConfirmDeleteParts, curfsm);
                return;
            }
        } else if (st == this.waitConfirmDeleteParts) {
            if (sig.equals("CheckSpecMsg")) {
                Vector removed = this.compareSpecs(asm.actorSpec.getPartDesc(), asm.newActorSpec.getPartDesc(), false);
                if (!removed.isEmpty()) {
                    for (int i = 0; i < removed.size(); ++i) {
                        PartSpec partSpec = (PartSpec)removed.elementAt(i);
                        asm.removedParts = asm.context.getChildrenRoles(partSpec.getRoleType());
                        asm.sendMessage("RoleRemoveMsg", asm.removedParts);
                    }
                    this.sameState(curfsm);
                    return;
                }
                this.performExit(curfsm);
                asm.removedParts = null;
                asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                this.nextState(this.waitConfirmUpdatePorts, curfsm);
                return;
            }
            if (sig.equals("RolePlayEndedMsg")) {
                for (int i = 0; i < asm.removedParts.size(); ++i) {
                    ActorAddress address = (ActorAddress)asm.removedParts.elementAt(i);
                    if (!address.equals(sig.getSenderRole())) continue;
                    asm.removedParts.removeElementAt(i);
                    curfsm.context.remove(sig.getSenderRole());
                    break;
                }
                if (asm.removedParts.isEmpty()) {
                    this.performExit(curfsm);
                    asm.removedParts = null;
                    asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                    this.nextState(this.waitConfirmUpdatePorts, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
        } else if (st == this.waitConfirmUpdatePorts) {
            if (sig.equals("CheckSpecMsg")) {
                Vector addedPorts = this.compareSpecs(asm.newActorSpec.getPortDesc(), asm.actorSpec.getPortDesc(), false);
                Vector c = (Vector)sig.getProperty("connectors");
                boolean newPortsCreated = curfsm.createPorts(c);
                if (newPortsCreated) {
                    curfsm.context.setTmpPorts(addedPorts, c);
                    this.sameState(curfsm);
                    return;
                }
                this.performExit(curfsm);
                asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                this.nextState(this.waitConfirmUpdateParts, curfsm);
                return;
            }
            if (sig.equals("PortCreateAckMsg")) {
                if (asm.context.allPortsAcked(sig.getSenderRole().getActorPort())) {
                    this.performExit(curfsm);
                    asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                    this.nextState(this.waitConfirmUpdateParts, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("PortCreateNackMsg")) {
                this.performExit(curfsm);
                if (asm.scheduler.isTraceOn()) {
                    asm.trace.traceError("ActorCS: Port creation failed, creation of ports aborted");
                }
                if (asm.context.getParentAddress().getActorID() != null) {
                    asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleCreateNackMsg", true), asm.context.getParentAddress());
                }
                asm.stopTimer("CreationTimer");
                AFPropertyMsg rpm = (AFPropertyMsg)curfsm.context.getRootPlayMsg();
                if (rpm != null) {
                    AFPropertyMsg msg = new AFPropertyMsg("RolePlayNackMsg", true);
                    msg.setProperty("RoleRequestMsg", rpm.getProperty("RoleRequestMsg"));
                    curfsm.sendMessage((ActorMsg)msg, rpm.getSenderRole());
                }
                asm.sendMessage((ActorMsg)new AFPropertyMsg("RoleRemoveMsg", true), asm.context.getActorAddress());
                if (asm.isVisible()) {
                    asm.stopTimer(ActorSM.ROUTER_UPDATE_INTERVAL_ID);
                }
                this.exitState(0, asm);
                return;
            }
            if (sig.equals("TimerMsg") && ((AFPropertyMsg)sig).getProperty("timerId").equals("CreationTimer")) {
                asm.createConnectors();
                this.sameState(curfsm);
                return;
            }
        } else if (st == this.waitConfirmUpdateParts) {
            if (sig.equals("CheckSpecMsg")) {
                Vector children = asm.getContext().getChildrenRoles();
                if (!children.isEmpty()) {
                    asm.sendMessage("RoleUpdateMsg", children);
                    asm.changedParts = children;
                    this.sameState(curfsm);
                    return;
                }
                this.performExit(curfsm);
                asm.changedParts = null;
                asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                this.nextState(this.waitAddedConnectors, curfsm);
                return;
            }
            if (sig.equals("RoleUpdateAckMsg")) {
                for (int i = 0; i < asm.changedParts.size(); ++i) {
                    ActorAddress actorAddress = (ActorAddress)asm.changedParts.elementAt(i);
                    if (!actorAddress.equals(sig.getSenderRole())) continue;
                    asm.changedParts.removeElementAt(i);
                    break;
                }
                if (asm.changedParts.isEmpty()) {
                    this.performExit(curfsm);
                    asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                    this.nextState(this.waitConfirmCreateParts, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleUpdateNackMsg")) {
                if (asm.scheduler.isTraceOn()) {
                    asm.trace.traceError("SuspenedCS: Inner part update failed");
                }
                this.performExit(curfsm);
                if (asm.context.getParentAddress().getActorID() != null) {
                    asm.sendMessage("RoleCreateNackMsg", asm.context.getParentAddress());
                }
                asm.stopTimer("CreationTimer");
                this.exitState(0, asm);
                return;
            }
        } else if (st == this.waitConfirmCreateParts) {
            if (sig.equals("CheckSpecMsg")) {
                boolean partsCreated = asm.createParts(asm.newActorSpec);
                if (partsCreated) {
                    Enumeration enumer = asm.context.getCreationOfChildren().elements();
                    while (enumer.hasMoreElements()) {
                        asm.context.getTmpPorts().addElement(enumer.nextElement());
                    }
                    if (asm.scheduler.isTraceOn()) {
                        asm.trace.traceTask("New parts defined");
                    }
                    asm.setNoOfTrialsLeft(3);
                    asm.startTimer(15000L, "CreationTimer");
                    this.sameState(curfsm);
                    return;
                }
                this.performExit(curfsm);
                asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                this.nextState(this.waitAddedConnectors, curfsm);
                return;
            }
            if (sig.equals("RoleCreateAckMsg")) {
                Vector v = asm.context.getCreationOfChildren();
                asm.context.removeCreationChild(sig.getSenderRole());
                sig.getSenderRole().setActorDomain(curfsm.getScheduler().getSchedulerData().getActorDomainName());
                asm.context.addPersistentChildrenRole(sig.getSenderRole());
                asm.sendMessage("SuspendMsg", sig.getSenderRole());
                if (asm.suspendedActors == null) {
                    asm.suspendedActors = new Vector();
                }
                asm.suspendedActors.addElement(sig.getSenderRole());
                if (v.isEmpty()) {
                    this.performExit(curfsm);
                    asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                    this.nextState(this.waitAddedConnectors, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("RoleCreateNackMsg")) {
                if (asm.scheduler.isTraceOn()) {
                    asm.trace.traceError("ActorCS: Inner part creation rejected -- creation of inner parts aborted");
                }
                this.performExit(curfsm);
                if (asm.context.getParentAddress().getActorID() != null) {
                    asm.sendMessage("RoleCreateNackMsg", asm.context.getParentAddress());
                }
                asm.sendMessage("RoleRemoveMsg", asm.context.getActorAddress());
                asm.stopTimer("CreationTimer");
                this.exitState(0, asm);
                return;
            }
            if (sig.equals("SuspendedMsg")) {
                for (int i = 0; i < asm.suspendedActors.size(); ++i) {
                    ActorAddress actorAddress = (ActorAddress)asm.suspendedActors.elementAt(i);
                    if (!actorAddress.equals(sig.getSenderRole())) continue;
                    asm.suspendedActors.removeElementAt(i);
                    break;
                }
                if (asm.suspendedActors.isEmpty()) {
                    this.performExit(curfsm);
                    this.nextState(this.suspended, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("TimerMsg") && sig.getProperty("timerId").equals("CreationTimer")) {
                Vector v = asm.context.getCreationOfChildren();
                if (!v.isEmpty()) {
                    if (asm.getNoOfTrialsLeft() > 0) {
                        asm.setNoOfTrialsLeft(asm.getNoOfTrialsLeft() - 1);
                        if (asm.createParts(v)) {
                            asm.startTimer(new AFPropertyMsg("TimerMsg", true), 15000L, "CreationTimer");
                        }
                    } else {
                        if (asm.scheduler.isTraceOn()) {
                            asm.trace.traceError("ActorCS: Creation Timeout, creation of inner parts aborted");
                        }
                        AFPropertyMsg pm = new AFPropertyMsg("RoleRemoveMsg", true);
                        asm.sendMessage((ActorMsg)pm, asm.context.getActorAddress());
                    }
                }
                this.sameState(asm);
                return;
            }
            if (!(sig.equals("RoleRemoveMsg") || sig.equals("RoleReleaseMsg") || sig.equals("RolePlayEndedMsg") || sig.equals("SetActorTraceMsg") || sig.equals("ReportRequestMsg") || sig.equals("ReportResponsMsg") || sig.equals("ActorReportTimerMsg"))) {
                this.save(sig, curfsm);
                this.sameState(curfsm);
                return;
            }
        } else if (st == this.waitAddedConnectors) {
            if (sig.equals("CheckSpecMsg")) {
                Vector addedConnectors = this.compareSpecs(asm.newActorSpec.getConnectorDesc(), asm.actorSpec.getConnectorDesc(), false);
                if ((addedConnectors = asm.rewriteContextualConnectors(addedConnectors)).isEmpty()) {
                    this.performExit(curfsm);
                    asm.sendMessage("RoleUpdateAckMsg", asm.roleUpdateSender);
                    asm.setActorSpec(asm.newActorSpec);
                    this.nextState(this.suspended, curfsm);
                    return;
                }
                for (int i = 0; i < addedConnectors.size(); ++i) {
                    ConnectorSpec connectorSpec = (ConnectorSpec)addedConnectors.elementAt(i);
                    AFPropertyMsg msg = new AFPropertyMsg("ConnectorAddMsg", true);
                    msg.setFrameworkMsg(true);
                    msg.setProperty("connectors", connectorSpec);
                    asm.sendMessage((ActorMsg)msg, connectorSpec.getFrom());
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("PortCreateAckMsg")) {
                if (asm.context.allPortsAcked(sig.getSenderRole().getActorPort())) {
                    this.performExit(curfsm);
                    asm.sendMessage("RoleUpdateAckMsg", asm.roleUpdateSender);
                    asm.setActorSpec(asm.newActorSpec);
                    this.nextState(this.suspended, curfsm);
                    return;
                }
                this.sameState(curfsm);
                return;
            }
            if (sig.equals("PortCreateNackMsg")) {
                this.performExit(curfsm);
                if (asm.scheduler.isTraceOn()) {
                    asm.trace.traceError("ActorCS: Port creation failed, creation of ports aborted");
                }
                this.exitState(0, asm);
                return;
            }
        } else {
            if (st == this.suspending) {
                if (sig.equals("SuspendedMsg")) {
                    for (int i = 0; i < asm.suspendedActors.size(); ++i) {
                        ActorAddress address = (ActorAddress)asm.suspendedActors.elementAt(i);
                        if (!address.equals(sig.getSenderRole())) continue;
                        asm.suspendedActors.removeElementAt(i);
                        break;
                    }
                    if (asm.suspendedActors.isEmpty()) {
                        this.performExit(curfsm);
                        curfsm.sendMessage("SuspendedMsg", asm.suspendActor);
                        asm.suspendedActors = null;
                        this.nextState(this.suspended, curfsm);
                        return;
                    }
                    this.sameState(curfsm);
                    return;
                }
                this.save(sig, curfsm);
                return;
            }
            if (st == this.suspended) {
                if (sig.equals("ResumeMsg")) {
                    asm.resumeActor = sig.getSenderRole();
                    asm.resumedActors = curfsm.context.getChildrenRoles();
                    if (asm.resumedActors.isEmpty()) {
                        this.performExit(curfsm);
                        curfsm.sendMessage("ResumedMsg", asm.resumeActor);
                        this.exitState(1, asm);
                        return;
                    }
                    curfsm.sendMessage((ActorMsg)new AFPropertyMsg("ResumeMsg", true), asm.resumedActors);
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("ResumedMsg")) {
                    for (int i = 0; i < asm.resumedActors.size(); ++i) {
                        ActorAddress address = (ActorAddress)asm.resumedActors.elementAt(i);
                        if (!address.equals(sig.getSenderRole())) continue;
                        asm.resumedActors.removeElementAt(i);
                        break;
                    }
                    if (asm.resumedActors.isEmpty()) {
                        this.performExit(curfsm);
                        curfsm.sendMessage("ResumedMsg", asm.resumeActor);
                        asm.resumedActors = null;
                        this.exitState(1, asm);
                        return;
                    }
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("SuspendMsg")) {
                    asm.sendMessage("SuspendedMsg", sig.getSenderRole());
                    this.sameState(curfsm);
                    return;
                }
                if (sig.equals("RoleRemoveMsg")) {
                    return;
                }
                if (sig.equals("RoleUpdateMsg")) {
                    asm.roleUpdateSender = sig.getSenderRole();
                    asm.newActorSpec = asm.getApplicationSpec().getClonedActorSpec(asm.getType());
                    if (asm.getActorSpec().equals(asm.newActorSpec)) {
                        asm.newActorSpec = null;
                        asm.sendMessage("RoleUpdateAckMsg", asm.roleUpdateSender);
                        this.sameState(curfsm);
                        return;
                    }
                    this.performExit(curfsm);
                    asm.sendMessage("CheckSpecMsg", asm.getMyActorAddress());
                    this.nextState(this.waitConfirmDeleteConnectors, curfsm);
                    return;
                }
                if (!(sig.equals("RoleRemoveMsg") || sig.equals("RoleReleaseMsg") || sig.equals("RolePlayEndedMsg") || sig.equals("SetActorTraceMsg") || sig.equals("ReportRequestMsg") || sig.equals("ReportResponsMsg") || sig.equals("ActorReportTimerMsg"))) {
                    this.save(sig, curfsm);
                    return;
                }
            }
        }
        if (sig.equals("TimerMsg") && sig.getProperty("timerId").equals("TimerRegId")) {
            return;
        }
    }

    private Vector compareSpecs(Vector from, Vector to, boolean equal) {
        Vector res = new Vector();
        for (int i = 0; i < from.size(); ++i) {
            Object oldcs = from.elementAt(i);
            boolean found = false;
            for (int j = 0; j < to.size(); ++j) {
                Object newcs = to.elementAt(j);
                if (!oldcs.equals(newcs)) continue;
                found = true;
                break;
            }
            if (equal && found) {
                res.addElement(oldcs);
                continue;
            }
            if (equal || found) continue;
            res.addElement(oldcs);
        }
        return res;
    }
}

