/*
 * Decompiled with CFR 0.152.
 */
package org.coos.javaframe;

import java.util.Hashtable;
import org.coos.javaframe.BasicLoggerImpl;
import org.coos.javaframe.Logger;

public class LoggerFactory {
    static boolean traceOn = true;
    static boolean traceError = true;
    private static Class LOGGER_IMPL_CLASS = null;
    private static Hashtable LOGGERS = new Hashtable();

    public static boolean isTraceOn() {
        return traceOn;
    }

    public static void setTrace(boolean enabled) {
        traceOn = enabled;
    }

    public static boolean isTraceError() {
        return traceError;
    }

    public static void setTraceError(boolean on) {
        traceError = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoggerImplClass(Class loggerImplClass) {
        LOGGER_IMPL_CLASS = loggerImplClass;
        if (loggerImplClass != null) {
            try {
                Logger logger = (Logger)LOGGER_IMPL_CLASS.newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed create instance of " + LOGGER_IMPL_CLASS.getClass().getName());
                System.err.println();
                e.printStackTrace();
            }
            finally {
                Logger logger = LoggerFactory.getLogger(LoggerFactory.class.getName());
                logger.log(2, "Using " + logger.getClass().getName());
            }
        }
    }

    private static Logger createLogger(Class clazz, String loggerName) throws Exception {
        Logger logger = (Logger)clazz.newInstance();
        logger.setLoggerName(loggerName);
        LOGGERS.put(loggerName, logger);
        return logger;
    }

    public static Logger getLogger(String loggerName) {
        Logger logger = (Logger)LOGGERS.get(loggerName);
        if (logger != null) {
            return logger;
        }
        try {
            if (LOGGER_IMPL_CLASS != null) {
                return LoggerFactory.createLogger(LOGGER_IMPL_CLASS, loggerName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return LoggerFactory.createLogger(Class.forName("org.coos.javaframe.J2SELoggerImpl"), loggerName);
        }
        catch (Exception e) {
            try {
                return LoggerFactory.createLogger(Class.forName("no.tellu.cdc.javaframe.LoggerImpl"), loggerName);
            }
            catch (Exception e2) {
                try {
                    return LoggerFactory.createLogger(Class.forName("org.coos.javaframe.CLDCLoggerImpl"), loggerName);
                }
                catch (Exception exception) {
                    logger = new BasicLoggerImpl(loggerName);
                    LOGGERS.put(loggerName, logger);
                    return logger;
                }
            }
        }
    }
}

