/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import org.coos.extender.BundleTracker;
import org.coos.extender.CoosContainer;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;

public final class CoosExtender
extends BundleTracker<CoosContainer> {
    private static final Log LOG = LogFactory.getLog(CoosExtender.class);
    private static final String CONFIG_DIR = "configDir";
    private static final String DEFAULT_CONFIG_DIR = "./coosConfig";
    private static final String COOS_CONTEXT = "Coos-Context";
    private static final String DEFAULT_COOS_CONTEXT = "/META-INF/coos";
    private final String configDir = System.getProperty("configDir", "./coosConfig");

    public CoosExtender(BundleContext context) {
        super(context, 32, null);
        LOG.info("Coos configuration directory: " + this.configDir);
    }

    @Override
    public CoosContainer addingBundle(Bundle bundle, BundleEvent event) {
        if (this.isCoosBundle(bundle)) {
            String coosContext = this.getCoosContext(bundle);
            CoosContainer container = new CoosContainer(bundle.getBundleContext(), bundle, coosContext, this.configDir);
            container.start();
            return container;
        }
        return null;
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent event, CoosContainer container) {
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, CoosContainer container) {
        container.stop();
    }

    private boolean isCoosBundle(Bundle bundle) {
        if (bundle.getHeaders().get(COOS_CONTEXT) != null) {
            LOG.debug("Bundle is a Coos bundle with context:" + bundle.getHeaders().get(COOS_CONTEXT));
            return true;
        }
        return bundle.getEntryPaths(DEFAULT_COOS_CONTEXT) != null;
    }

    private String getCoosContext(Bundle bundle) {
        String coosContext = (String)bundle.getHeaders().get(COOS_CONTEXT);
        if (coosContext == null) {
            return DEFAULT_COOS_CONTEXT;
        }
        return coosContext;
    }
}

