/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class AbstractTracked<T, R, O> {
    static final boolean DEBUG = false;
    private final Map<T, O> tracked = new HashMap<T, O>();
    private int trackingCount = 0;
    private final List<T> adding = new ArrayList<T>(6);
    volatile boolean closed = false;
    private final Deque<T> initial = new LinkedList<T>();

    AbstractTracked() {
    }

    void setInitial(T[] list) {
        if (list == null) {
            return;
        }
        for (T item : list) {
            if (item == null) continue;
            this.initial.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackInitial() {
        while (true) {
            T item;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed || this.initial.size() == 0) {
                    return;
                }
                item = this.initial.removeFirst();
                if (this.tracked.get(item) != null) {
                    continue;
                }
                if (this.adding.contains(item)) {
                    continue;
                }
                this.adding.add(item);
            }
            this.trackAdding(item, null);
        }
    }

    void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void track(T item, R related) {
        O object;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.closed) {
                return;
            }
            object = this.tracked.get(item);
            if (object == null) {
                if (this.adding.contains(item)) {
                    return;
                }
                this.adding.add(item);
            } else {
                this.modified();
            }
        }
        if (object == null) {
            this.trackAdding(item, related);
        } else {
            this.customizerModified(item, related, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackAdding(T item, R related) {
        O object = null;
        boolean becameUntracked = false;
        try {
            object = this.customizerAdding(item, related);
        }
        finally {
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.adding.remove(item) && !this.closed) {
                    if (object != null) {
                        this.tracked.put(item, object);
                        this.modified();
                        this.notifyAll();
                    }
                } else {
                    becameUntracked = true;
                }
            }
        }
        if (becameUntracked && object != null) {
            this.customizerRemoved(item, related, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void untrack(T item, R related) {
        O object;
        AbstractTracked abstractTracked = this;
        synchronized (abstractTracked) {
            if (this.initial.remove(item)) {
                return;
            }
            if (this.adding.remove(item)) {
                return;
            }
            object = this.tracked.remove(item);
            if (object == null) {
                return;
            }
            this.modified();
        }
        this.customizerRemoved(item, related, object);
    }

    int size() {
        return this.tracked.size();
    }

    O getCustomizedObject(T item) {
        return this.tracked.get(item);
    }

    T[] getTracked(T[] list) {
        return this.tracked.keySet().toArray(list);
    }

    void modified() {
        ++this.trackingCount;
    }

    int getTrackingCount() {
        return this.trackingCount;
    }

    abstract O customizerAdding(T var1, R var2);

    abstract void customizerModified(T var1, R var2, O var3);

    abstract void customizerRemoved(T var1, R var2, O var3);
}

