/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.coos.messaging.COContainer;
import org.coos.messaging.Channel;
import org.coos.messaging.ChannelServer;
import org.coos.messaging.ConnectingException;
import org.coos.messaging.Plugin;
import org.coos.messaging.PluginFactory;
import org.coos.messaging.impl.DefaultChannel;
import org.coos.messaging.plugin.PluginChannel;
import org.coos.messaging.transport.JvmTransport;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.coos.util.macro.MacroSubstituteReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class CoosContainer
implements COContainer {
    private static final Log LOG = LogFactory.getLog(CoosContainer.class);
    private final BundleContext context;
    private final Bundle bundle;
    private final String contextDir;
    private final File configDir;
    private final List<Plugin> plugins;

    public CoosContainer(BundleContext context, Bundle bundle, String contextDir, String configDir) {
        this.context = context;
        this.bundle = bundle;
        this.contextDir = contextDir;
        this.configDir = new File(configDir);
        this.plugins = new ArrayList<Plugin>();
    }

    void start() {
        LOG.info("OSGi plugin container starting [" + this.bundle.getSymbolicName() + "]");
        List<String> pluginDefs = this.findPluginDefinitions();
        if (pluginDefs.isEmpty()) {
            LOG.warn("The plugin container has no plugin definitions");
        } else {
            this.createPlugins(pluginDefs);
        }
        LOG.info("OSGi plugin container started [" + this.bundle.getSymbolicName() + "]");
    }

    void stop() {
        LOG.info("OSGi plugin container stopping [" + this.bundle.getSymbolicName() + "]");
        for (Plugin plugin : this.plugins) {
            plugin.disconnect();
        }
        LOG.info("OSGi plugin container stopped [" + this.bundle.getSymbolicName() + "]");
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return this.bundle.loadClass(className);
        }
        catch (IllegalStateException ex) {
            throw new ClassNotFoundException("BundleContext no longer valid", ex);
        }
    }

    public InputStream getResource(String resourceName) throws IOException {
        try {
            URL resourceUrl = this.getResourceUrl(resourceName);
            if (resourceUrl == null) {
                return null;
            }
            InputStream stream = resourceUrl.openStream();
            if (resourceName.endsWith(".xml")) {
                return this.substitute(stream);
            }
            return stream;
        }
        catch (IllegalStateException ex) {
            throw new IOException("BundleContext no longer valid", ex);
        }
    }

    public Object getObject(String name) {
        if ("BundleContext".equals(name)) {
            return this.context;
        }
        return null;
    }

    private List<String> findPluginDefinitions() {
        LOG.info("Searching for plugin definitions in " + this.contextDir);
        ArrayList<String> definitions = new ArrayList<String>();
        Enumeration entries = this.bundle.findEntries(this.contextDir, "plugin*.xml", false);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                String path = entry.getFile();
                String file = path.substring(path.lastIndexOf(47));
                definitions.add(file);
            }
        }
        return definitions;
    }

    private void createPlugins(List<String> pluginDefs) {
        for (String pluginDef : pluginDefs) {
            try {
                LOG.info("Starting plugins defined in " + this.contextDir + pluginDef);
                this.createPlugins(this.getResource(pluginDef));
            }
            catch (Exception ex) {
                LOG.warn("Failed to load plugins defined in " + pluginDef + ": " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void createPlugins(InputStream pluginDef) throws Exception {
        ArrayList<Plugin> connectedPlugins = new ArrayList<Plugin>();
        try {
            Plugin[] newPlugins;
            for (Plugin plugin : newPlugins = PluginFactory.createPlugins((InputStream)pluginDef, (COContainer)this)) {
                this.startPlugin(plugin);
                connectedPlugins.add(plugin);
            }
        }
        catch (Exception ex) {
            for (Plugin plugin : connectedPlugins) {
                plugin.disconnect();
            }
            throw ex;
        }
        this.plugins.addAll(connectedPlugins);
    }

    private void startPlugin(Plugin plugin) throws ConnectingException {
        for (Channel channel : plugin.getChannels()) {
            if (!(channel instanceof PluginChannel) || !(((DefaultChannel)channel).getTransport() instanceof JvmTransport)) continue;
            JvmTransport transport = (JvmTransport)((DefaultChannel)channel).getTransport();
            ChannelServer channelServer = this.getChannelServer();
            transport.setChannelServer(channelServer);
        }
        plugin.connect();
    }

    private ChannelServer getChannelServer() {
        ServiceReference reference = this.context.getServiceReference(ChannelServer.class.getName());
        if (reference == null) {
            throw new RuntimeException("No ChannelServer is registered with the OSGi framework");
        }
        return (ChannelServer)this.context.getService(reference);
    }

    private URL getResourceUrl(String resourceName) {
        URL resourceUrl = this.getConfigResourceUrl(resourceName);
        if (resourceUrl == null) {
            resourceUrl = this.getBundleResourceUrl(resourceName);
        }
        return resourceUrl;
    }

    private URL getConfigResourceUrl(String resourceName) {
        File resource = new File(this.configDir, resourceName);
        if (resource.exists() && resource.isFile()) {
            try {
                LOG.info("Container resource [" + this.getBundleResourceName(resourceName) + "] overridden by [" + resource + "]");
                return resource.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private URL getBundleResourceUrl(String resourceName) {
        return this.bundle.getResource(this.getBundleResourceName(resourceName));
    }

    private String getBundleResourceName(String resourceName) {
        if (resourceName != null && resourceName.length() > 0 && resourceName.charAt(0) == '/') {
            return this.contextDir + resourceName;
        }
        return this.contextDir + "/" + resourceName;
    }

    private InputStream substitute(InputStream stream) throws IOException {
        InputStreamReader isr = new InputStreamReader(stream);
        MacroSubstituteReader msr = new MacroSubstituteReader((Reader)isr);
        String substituted = msr.substituteMacros();
        return new ByteArrayInputStream(substituted.getBytes());
    }
}

