/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.extender;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.coos.messaging.COOS;
import org.coos.messaging.COOSFactory;
import org.coos.messaging.ChannelServer;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGICoosContainer extends OSGICOContainer {

    private static final Log LOG = LogFactory.getLog(OSGICoosContainer.class);
    private final List<COOS> COOSs; //Not in use yet
    private COOS coos;
    private static final String COOS_CONFIG_FILE = "/coos.xml";

    public OSGICoosContainer(BundleContext context, Bundle bundle,
            String contextDir, String configDir, CoosExtender extender) {
        super(context, bundle, contextDir, configDir, extender);
        this.COOSs=new ArrayList<COOS>();
    }

    @Override
    public void start() throws Exception {
        LOG.info("OSGI COOS Container starting");
        final List<String> coosDefs = findCoosDefinitions();
        createCOOSs(coosDefs);

    }

    private void createCOOSs(List<String> coosDefs) throws Exception {
        InputStream is = null;
        try {
            LOG.debug("Looking for coos.xml in: "+configDir + COOS_CONFIG_PATH + COOS_CONFIG_FILE);
            is = new FileInputStream(configDir + COOS_CONFIG_PATH + COOS_CONFIG_FILE);
            is = substitute(is);
        } catch (FileNotFoundException e) {
        } catch (Exception e) {
            LOG.warn("Exception trying to get config: " + e.getMessage());
            e.printStackTrace();
        }

        if (is != null) {
            LOG.info("Using provided coos config");
        } else {
            URL url = context.getBundle().getResource(COOS_CONFIG_PATH + COOS_CONFIG_FILE);
            if (url == null) {
                LOG.warn("This coos bundle has no Coos configuration!");
                throw new Exception("Bundle has no configuration");
            }
            try {
                is = url.openStream();
                is = substitute(is);
            } catch (IOException e) {
                e.printStackTrace();
                throw e;
            }

            LOG.info("Using included coos config");
        }
        LOG.info("Starting COOS(s) defined in " + COOS_CONFIG_FILE);
        try {
            coos = COOSFactory.createCOOS(is, this);
            coos.start();
        } catch (Exception e) {
            LOG.info("Failed to load COOS(s) defined in " + COOS_CONFIG_FILE);
            e.printStackTrace();
            throw e;
        }

        ChannelServer channelServer = coos.getChannelServer("default");
        context.registerService(ChannelServer.class.getName(), channelServer, new Hashtable());
        LOG.info("ChannelServer registered");
    }

    private List<String> findCoosDefinitions() {
        List <String> defs=new ArrayList<String>();
        //TODO: MORE COOSs
        return defs;
    }

    @Override
    public void stop() throws Exception {
        LOG.info("OSGI COOS container stopping");
        coos.stop();
    }

}
