/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import java.util.Hashtable;
import org.coos.extender.BundleClassLoader;
import org.coos.extender.BundleTracker;
import org.coos.extender.OSGICOContainer;
import org.coos.extender.OSGICoosContainer;
import org.coos.extender.OSGICoosPluginContainer;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;

public final class CoosExtender
extends BundleTracker<OSGICOContainer> {
    private static final Log LOG = LogFactory.getLog(CoosExtender.class);
    private static final String CONFIG_DIR = "configDir";
    private static final String DEFAULT_CONFIG_DIR = "./coosConfig";
    private static final String COOS_PLUGIN_CONTEXT = "CoosPlugin-Context";
    private static final String COOS_CONTEXT = "Coos-Context";
    private static final String DEFAULT_COOS_CONTEXT = "/META-INF/coos";
    private static final String COOS_PROCESSOR = "Coos-Processor";
    public static final String COOS_TIMEOUT = "Coos-Timeout";
    public static final long DEFAULT_COOS_TIMEOUT = 10L;
    private final String configDir = System.getProperty("configDir", "./coosConfig");
    private Hashtable<String, ClassLoader> procClassLoaders;

    public CoosExtender(BundleContext context) {
        super(context, 32, null);
        LOG.info("Coos configuration directory: " + this.configDir);
        this.procClassLoaders = new Hashtable();
    }

    @Override
    public OSGICOContainer addingBundle(Bundle bundle, BundleEvent event) {
        String coosContext;
        LOG.debug("Got bundle starting: " + bundle.getSymbolicName());
        if (this.isProcessorProvider(bundle)) {
            LOG.debug("Bundle is ProcessorProvider.");
            String[] providedProcessors = this.getCoosProcessors(bundle);
            for (int i = 0; i < providedProcessors.length; ++i) {
                LOG.debug("Adding classloader to class: '" + providedProcessors[i] + "'");
                this.procClassLoaders.put(providedProcessors[i], new BundleClassLoader(bundle));
            }
        }
        if (this.isCoosPluginBundle(bundle)) {
            coosContext = this.getCoosPluginContext(bundle);
            LOG.debug("Bundle is a COOS Plugin bundle with context:" + coosContext);
            OSGICoosPluginContainer container = new OSGICoosPluginContainer(bundle.getBundleContext(), bundle, coosContext, this.configDir, this);
            this.startContainer(container);
            return container;
        }
        if (this.isCoosBundle(bundle)) {
            coosContext = this.getCoosContext(bundle);
            LOG.debug("Bundle is a COOS bundle with context:" + coosContext);
            OSGICoosContainer container = new OSGICoosContainer(bundle.getBundleContext(), bundle, coosContext, this.configDir, this);
            this.startContainer(container);
            return container;
        }
        LOG.debug("Ignoring bundle " + bundle.getSymbolicName() + " - not a Coos bundle");
        return null;
    }

    private void startContainer(final OSGICOContainer container) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    container.start();
                }
                catch (Exception e) {
                    try {
                        container.bundle.stop();
                    }
                    catch (BundleException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }

    @Override
    public Bundle[] parseInitialBundleArray(Bundle[] bundles) {
        return bundles;
    }

    private boolean isProcessorProvider(Bundle bundle) {
        String coosContext = (String)bundle.getHeaders().get(COOS_PROCESSOR);
        return coosContext != null;
    }

    private ClassLoader getProcClassLoader(String processorClassName) {
        return this.procClassLoaders.get(processorClassName);
    }

    public Class<?> loadProcessorClass(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getProcClassLoader(className);
        if (cl != null) {
            return cl.loadClass(className);
        }
        throw new ClassNotFoundException("ClassLoader from extender is null");
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent event, OSGICOContainer container) {
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, OSGICOContainer container) {
        LOG.debug("bundle stopping: " + bundle.getSymbolicName());
        if (this.isProcessorProvider(bundle)) {
            LOG.debug("Bundle provides Processors");
            String[] providedProcessors = this.getCoosProcessors(bundle);
            for (int i = 0; i < providedProcessors.length; ++i) {
                LOG.debug("Removing classloader to class: '" + providedProcessors[i] + "'");
                this.procClassLoaders.remove(providedProcessors[i]);
            }
        }
        try {
            container.stop();
            LOG.info("COOSs stopped");
        }
        catch (Exception e) {
            try {
                container.bundle.stop();
            }
            catch (BundleException e1) {
                e1.printStackTrace();
            }
        }
    }

    private boolean isCoosPluginBundle(Bundle bundle) {
        return this.isBundle(bundle, COOS_PLUGIN_CONTEXT);
    }

    private boolean isCoosBundle(Bundle bundle) {
        return this.isBundle(bundle, COOS_CONTEXT);
    }

    private boolean isBundle(Bundle bundle, String context) {
        if (bundle.getHeaders().get(context) != null) {
            return true;
        }
        return bundle.getEntryPaths(DEFAULT_COOS_CONTEXT) != null;
    }

    private String[] getCoosProcessors(Bundle bundle) {
        String[] providedProcessors = ((String)bundle.getHeaders().get(COOS_PROCESSOR)).split("\\,");
        for (int i = 0; i < providedProcessors.length; ++i) {
            providedProcessors[i] = providedProcessors[i].trim();
        }
        return providedProcessors;
    }

    private String getCoosPluginContext(Bundle bundle) {
        return this.getContext(bundle, COOS_PLUGIN_CONTEXT);
    }

    private String getCoosContext(Bundle bundle) {
        return this.getContext(bundle, COOS_CONTEXT);
    }

    private String getContext(Bundle bundle, String context) {
        String coosContext = (String)bundle.getHeaders().get(context);
        if (coosContext == null) {
            return DEFAULT_COOS_CONTEXT;
        }
        return coosContext;
    }
}

