/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.coos.extender.CoosExtender;
import org.coos.extender.OSGICOContainer;
import org.coos.messaging.COContainer;
import org.coos.messaging.COOS;
import org.coos.messaging.COOSFactory;
import org.coos.messaging.ChannelServer;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGICoosContainer
extends OSGICOContainer {
    private static final Log LOG = LogFactory.getLog(OSGICoosContainer.class);
    private final List<COOS> COOSs = new ArrayList<COOS>();
    private COOS coos;
    private static final String COOS_CONFIG_FILE = "/coos.xml";

    public OSGICoosContainer(BundleContext context, Bundle bundle, String contextDir, String configDir, CoosExtender extender) {
        super(context, bundle, contextDir, configDir, extender);
    }

    public void start() throws Exception {
        LOG.info("OSGI COOS Container starting");
        List<String> coosDefs = this.findCoosDefinitions();
        this.createCOOSs(coosDefs);
    }

    private void createCOOSs(List<String> coosDefs) throws Exception {
        InputStream is = null;
        try {
            LOG.debug("Looking for coos.xml in: " + this.configDir + "/org/coos/config" + COOS_CONFIG_FILE);
            is = new FileInputStream(this.configDir + "/org/coos/config" + COOS_CONFIG_FILE);
            is = this.substitute(is);
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            LOG.warn("Exception trying to get config: " + e.getMessage());
            e.printStackTrace();
        }
        if (is != null) {
            LOG.info("Using provided coos config");
        } else {
            URL url = this.context.getBundle().getResource("/org/coos/config/coos.xml");
            if (url == null) {
                LOG.warn("This coos bundle has no Coos configuration!");
                throw new Exception("Bundle has no configuration");
            }
            try {
                is = url.openStream();
                is = this.substitute(is);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            LOG.info("Using included coos config");
        }
        LOG.info("Starting COOS(s) defined in /coos.xml");
        try {
            this.coos = COOSFactory.createCOOS(is, (COContainer)this);
            this.coos.start();
        }
        catch (Exception e) {
            LOG.info("Failed to load COOS(s) defined in /coos.xml");
            e.printStackTrace();
            throw e;
        }
        ChannelServer channelServer = this.coos.getChannelServer("default");
        this.context.registerService(ChannelServer.class.getName(), (Object)channelServer, new Hashtable());
        LOG.info("ChannelServer registered");
    }

    private List<String> findCoosDefinitions() {
        ArrayList<String> defs = new ArrayList<String>();
        return defs;
    }

    public void stop() throws Exception {
        LOG.info("OSGI COOS container stopping");
        this.coos.stop();
    }
}

