/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.coos.extender.CoosExtender;
import org.coos.extender.OSGICOContainer;
import org.coos.messaging.COContainer;
import org.coos.messaging.COOS;
import org.coos.messaging.COOSFactory;
import org.coos.messaging.ChannelServer;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGICoosContainer
extends OSGICOContainer {
    private static final Log LOG = LogFactory.getLog(OSGICoosContainer.class);
    private final List<COOS> COOSs = Collections.synchronizedList(new ArrayList());

    public OSGICoosContainer(BundleContext context, Bundle bundle, String contextDir, String configDir, CoosExtender extender) {
        super(context, bundle, contextDir, configDir, extender);
    }

    public void start() throws Exception {
        LOG.info("OSGI COOS Container starting");
        List<String> coosDefs = this.findCoosDefinitions();
        this.createCOOSs(coosDefs);
    }

    private void createCOOSs(List<String> coosDefs) throws Exception {
        for (String coosDef : coosDefs) {
            try {
                LOG.info("Starting cooses defined in " + this.contextDir + coosDef);
                this.createCOOS(this.getResource(coosDef));
            }
            catch (Exception ex) {
                LOG.warn("Failed to load coos defined in " + coosDef + ": " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void createCOOS(InputStream is) throws Exception {
        COOS coos = null;
        try {
            coos = COOSFactory.createCOOS((InputStream)is, (COContainer)this);
            coos.start();
        }
        catch (Exception e) {
            LOG.info("Failed to load COOS(s)");
            e.printStackTrace();
            throw e;
        }
        this.COOSs.add(coos);
        ChannelServer channelServer = coos.getChannelServer("default");
        this.context.registerService(ChannelServer.class.getName(), (Object)channelServer, new Hashtable());
        LOG.info("ChannelServer registered");
    }

    private List<String> findCoosDefinitions() {
        LOG.info("Searching for coos definitions in " + this.contextDir);
        ArrayList<String> definitions = new ArrayList<String>();
        Enumeration entries = this.bundle.findEntries(this.contextDir, "coos*.xml", false);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                String path = entry.getFile();
                String file = new String(path.substring(path.lastIndexOf(47) + 1));
                definitions.add(file);
            }
        }
        File filConfigDir = new File(this.configDir.getAbsolutePath() + "/" + this.contextDir);
        LOG.info("Searching for plugin definitions in " + filConfigDir);
        ArrayList<String> configDirDefinitions = new ArrayList<String>();
        for (String pluginName : definitions) {
            final String pluginStart = pluginName.substring(0, pluginName.indexOf(".xml"));
            String[] files = filConfigDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(pluginStart) && name.endsWith(".xml");
                }
            });
            ArrayList res = new ArrayList();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                configDirDefinitions.add(files[i]);
            }
        }
        if (configDirDefinitions.size() > 0) {
            return configDirDefinitions;
        }
        return definitions;
    }

    public void stop() throws Exception {
        LOG.info("OSGI COOS container stopping");
        for (COOS coos : this.COOSs) {
            coos.stop();
        }
    }
}

