/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.coos.extender.CoosExtender;
import org.coos.messaging.BaseCOContainer;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OSGICOContainer
extends BaseCOContainer {
    private static final Log LOG = LogFactory.getLog(OSGICOContainer.class);
    protected final BundleContext context;
    protected final Bundle bundle;
    protected final String contextDir;
    protected final File configDir;
    private CoosExtender extender;

    public OSGICOContainer(BundleContext context, Bundle bundle, String contextDir, String configDir, CoosExtender extender) {
        this.context = context;
        this.bundle = bundle;
        this.contextDir = contextDir;
        this.configDir = new File(configDir);
        this.extender = extender;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            try {
                return this.bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                String timeout = (String)this.context.getBundle().getHeaders().get("Coos-Timeout");
                long startTime = System.currentTimeMillis();
                long duration = 10L;
                int n = 0;
                if (timeout != null) {
                    duration = Long.parseLong(timeout);
                }
                long stopTime = startTime + duration * 1000L;
                while (System.currentTimeMillis() < stopTime) {
                    try {
                        return this.extender.loadProcessorClass(className);
                    }
                    catch (ClassNotFoundException e2) {
                        LOG.info("Did not find class " + className + ", Waited " + n++ + " sec up to " + duration);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            LOG.warn("InterruptedException ignored.", (Exception)e1);
                        }
                    }
                }
                throw new ClassNotFoundException("Extender didn't find class within timeout time: " + className);
            }
        }
        catch (IllegalStateException ex) {
            throw new ClassNotFoundException("BundleContext no longer valid", ex);
        }
    }

    public InputStream getResource(String resourceName) throws IOException {
        try {
            URL resourceUrl = this.getResourceUrl(resourceName);
            if (resourceUrl == null) {
                return null;
            }
            InputStream stream = resourceUrl.openStream();
            if (resourceName.endsWith(".xml")) {
                return this.substitute(stream);
            }
            return stream;
        }
        catch (IllegalStateException ex) {
            throw new IOException("BundleContext no longer valid");
        }
    }

    public Object getObject(String name) {
        ServiceReference reference;
        if ("BundleContext".equals(name)) {
            return this.context;
        }
        if ("ClassLoader".equals(name)) {
            return new ClassLoader(){

                @Override
                public Class<?> loadClass(String className) throws ClassNotFoundException {
                    return OSGICOContainer.this.context.getBundle().loadClass(className);
                }
            };
        }
        if (name != null && (reference = this.context.getServiceReference(name)) != null) {
            return this.context.getService(reference);
        }
        return null;
    }

    private URL getBundleResourceUrl(String resourceName) {
        return this.bundle.getResource(this.getBundleResourceName(resourceName));
    }

    private String getBundleResourceName(String resourceName) {
        if (resourceName != null && resourceName.length() > 0 && resourceName.charAt(0) == '/') {
            return this.contextDir + resourceName;
        }
        return this.contextDir + "/" + resourceName;
    }

    private URL getResourceUrl(String resourceName) {
        URL resourceUrl = this.getConfigResourceUrl(resourceName);
        if (resourceUrl == null) {
            resourceUrl = this.getBundleResourceUrl(resourceName);
        }
        return resourceUrl;
    }

    private URL getConfigResourceUrl(String resourceName) {
        File resource = new File(this.configDir + "/" + this.contextDir, resourceName);
        if (resource.exists() && resource.isFile()) {
            try {
                LOG.info("Container resource [" + this.getBundleResourceName(resourceName) + "] overridden by [" + resource + "]");
                return resource.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

