/*
 * Decompiled with CFR 0.152.
 */
package org.coos.extender;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import org.coos.extender.CoosExtender;
import org.coos.extender.OSGICOContainer;
import org.coos.messaging.COContainer;
import org.coos.messaging.Channel;
import org.coos.messaging.ChannelServer;
import org.coos.messaging.ConnectingException;
import org.coos.messaging.Plugin;
import org.coos.messaging.PluginFactory;
import org.coos.messaging.plugin.PluginChannel;
import org.coos.messaging.transport.JvmTransport;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGICoosPluginContainer
extends OSGICOContainer {
    private static final Log LOG = LogFactory.getLog(OSGICoosPluginContainer.class);
    private final List<Plugin> plugins = new ArrayList<Plugin>();

    public OSGICoosPluginContainer(BundleContext context, Bundle bundle, String contextDir, String configDir, CoosExtender extender) {
        super(context, bundle, contextDir, configDir, extender);
    }

    public void start() throws Exception {
        LOG.info("OSGi plugin container starting [" + this.bundle.getSymbolicName() + "]");
        List<String> pluginDefs = this.findPluginDefinitions();
        if (pluginDefs.isEmpty()) {
            LOG.warn("The plugin container has no plugin definitions");
            throw new Exception("No plugin definitions");
        }
        this.createPlugins(pluginDefs);
        LOG.info("OSGi plugin container started [" + this.bundle.getSymbolicName() + "]");
    }

    public void stop() throws Exception {
        LOG.info("OSGi plugin container stopping [" + this.bundle.getSymbolicName() + "]");
        for (Plugin plugin : this.plugins) {
            plugin.disconnect();
        }
        LOG.info("OSGi plugin container stopped [" + this.bundle.getSymbolicName() + "]");
    }

    private List<String> findPluginDefinitions() {
        LOG.info("Searching for plugin definitions in " + this.contextDir);
        ArrayList<String> definitions = new ArrayList<String>();
        Enumeration entries = this.bundle.findEntries(this.contextDir, "plugin*.xml", false);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                String path = entry.getFile();
                String file = new String(path.substring(path.lastIndexOf(47) + 1));
                definitions.add(file);
            }
        }
        File filConfigDir = new File(this.configDir.getAbsolutePath() + "/" + this.contextDir);
        LOG.info("Searching for plugin definitions in " + filConfigDir);
        ArrayList<String> configDirDefinitions = new ArrayList<String>();
        for (final String pluginName : definitions) {
            final String pluginStart = pluginName.substring(0, pluginName.indexOf(".xml"));
            String[] files = filConfigDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.equals(pluginName) || name.startsWith(pluginStart + "-") && name.endsWith(".xml");
                }
            });
            ArrayList res = new ArrayList();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                configDirDefinitions.add(files[i]);
            }
        }
        if (configDirDefinitions.size() > 0) {
            return configDirDefinitions;
        }
        return definitions;
    }

    private void createPlugins(List<String> pluginDefs) throws Exception {
        for (String pluginDef : pluginDefs) {
            try {
                LOG.info("Starting plugins defined in " + this.contextDir + "/" + pluginDef);
                this.createPlugins(this.getResource(pluginDef));
            }
            catch (Exception ex) {
                LOG.warn("Failed to load plugins defined in " + pluginDef + ": " + ex.getMessage());
                throw ex;
            }
        }
    }

    private void createPlugins(InputStream pluginDef) throws Exception {
        ArrayList<Plugin> connectedPlugins = new ArrayList<Plugin>();
        try {
            Plugin[] newPlugins;
            for (Plugin plugin : newPlugins = PluginFactory.createPlugins((InputStream)pluginDef, (COContainer)this)) {
                this.startPlugin(plugin);
                connectedPlugins.add(plugin);
            }
        }
        catch (Exception ex) {
            for (Plugin plugin : connectedPlugins) {
                plugin.disconnect();
            }
            throw ex;
        }
        this.plugins.addAll(connectedPlugins);
    }

    private void startPlugin(Plugin plugin) throws ConnectingException {
        for (Channel channel : plugin.getChannels()) {
            if (!(channel instanceof PluginChannel) || !(channel.getTransport() instanceof JvmTransport)) continue;
            JvmTransport transport = (JvmTransport)channel.getTransport();
            ChannelServer channelServer = this.getChannelServer();
            transport.setChannelServer(channelServer);
        }
        plugin.connect();
    }

    private ChannelServer getChannelServer() {
        ServiceTracker tracker = new ServiceTracker(this.context, ChannelServer.class.getName(), null);
        tracker.open(true);
        Object tracked = null;
        try {
            tracked = this.getTrackedService(tracker);
            if (tracked == null) {
                throw new RuntimeException("Couldn't find ChannelServer in the OSGi framework");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("No ChannelServer is registered with the OSGi framework", e);
        }
        return tracked;
    }

    private <T> T getTrackedService(ServiceTracker serviceTracker) {
        int max = 150;
        Object service = null;
        for (int timeout = 1; service == null && timeout < max; ++timeout) {
            GregorianCalendar calendar = new GregorianCalendar();
            LOG.info(calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13) + " : Waited " + Integer.valueOf(timeout) + " seconds for messaging implementation.");
            try {
                service = serviceTracker.waitForService(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("InteruptException ignored", (Exception)e);
            }
        }
        return (T)service;
    }
}

