/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.plugin.logserver.api;

import java.io.Serializable;
import java.util.Hashtable;

import org.coos.messaging.Exchange;
import org.coos.messaging.ExchangePattern;
import org.coos.messaging.Message;
import org.coos.messaging.impl.DefaultExchange;
import org.coos.messaging.impl.DefaultMessage;

/**
 * Message factory for the LogServer plugin.
 * 
 * @author Robert Bj&aelig;rum, Tellu AS
 *
 */
public class LogMessageFactory {

	public static Exchange createSendEventExchange(byte[] serializedEvent) {
		Exchange ex = new DefaultExchange(new ExchangePattern(ExchangePattern.OutOnly));
		Message msg = new DefaultMessage(LogMessageProperties.SEND_LOGGING_EVENT);
		Hashtable<String, Object> props = new Hashtable<String, Object>();
		props.put(LogMessageProperties.EVENT, serializedEvent);
		msg.setBody(props);
		ex.setOutBoundMessage(msg);
		return ex;
	}
}
