/*
 * Decompiled with CFR 0.152.
 */
package org.coos.publishsubscribe;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.coos.messaging.Endpoint;
import org.coos.messaging.Exchange;
import org.coos.messaging.ExchangePattern;
import org.coos.messaging.InteractionHelper;
import org.coos.messaging.Message;
import org.coos.messaging.impl.DefaultConsumer;
import org.coos.messaging.impl.DefaultMessage;
import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.coos.publishsubscribe.Covering;

public class NotificationConsumer
extends DefaultConsumer {
    private Map<Message, String> subscriptions = new HashMap<Message, String>();
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public NotificationConsumer(Endpoint endpoint) {
        super(endpoint);
    }

    public synchronized void process(Exchange exchange) {
        Message msg = exchange.getInBoundMessage();
        if (msg.getName().equals("sub")) {
            this.subscriptions.put(msg, msg.getSenderEndpointUri());
            this.logger.info("Subscription received from: " + msg.getSenderEndpointUri());
            if (exchange.getPattern().equals((Object)"InOut")) {
                exchange.setOutBoundMessage((Message)new DefaultMessage("subOk"));
                InteractionHelper helper = new InteractionHelper(this.getEndpoint());
                helper.send(msg.getSenderEndpointUri(), exchange);
            }
        } else if (msg.getName().equals("unsub")) {
            this.subscriptions.remove(msg);
            this.logger.info("UnSubscription received from: " + msg.getSenderEndpointUri());
        } else if (msg.getName().equals("unsub_all")) {
            Set<Map.Entry<Message, String>> entrySet = this.subscriptions.entrySet();
            Iterator<Map.Entry<Message, String>> it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry<Message, String> entry = it.next();
                if (!entry.getValue().equalsIgnoreCase(msg.getSenderEndpointUri())) continue;
                it.remove();
            }
            this.logger.info("UnSubscription (all filters) received from: " + msg.getSenderEndpointUri());
        } else if (msg.getName().equals("notify")) {
            HashSet<String> sSet = new HashSet<String>();
            for (Message filter : this.subscriptions.keySet()) {
                if (!Covering.apply(filter, msg)) continue;
                sSet.add(this.subscriptions.get(filter));
            }
            for (String uri : sSet) {
                Exchange ex = this.getEndpoint().createExchange(new ExchangePattern("OutOnly"));
                try {
                    ex.setOutBoundMessage(msg.copy());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                InteractionHelper helper = new InteractionHelper(this.getEndpoint());
                helper.send(uri, ex);
            }
        }
    }
}

