/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.publishsubscribe;

import org.coos.messaging.util.Log;
import org.coos.messaging.util.LogFactory;
import org.coos.messaging.*;
import org.coos.messaging.impl.DefaultConsumer;
import org.coos.messaging.impl.DefaultMessage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

public class NotificationConsumer extends DefaultConsumer {

	private Map<Message, String> subscriptions = new HashMap<Message, String>();
	private final Log logger = LogFactory.getLog(this.getClass());

	public NotificationConsumer(Endpoint endpoint) {
		super(endpoint);
	}

	public synchronized void process(Exchange exchange) {

		Message msg = exchange.getInBoundMessage();

		if (msg.getName().equals(SubscriptionFilter.SUBSCRIBE)) {
			subscriptions.put(msg, msg.getSenderEndpointUri());
			logger.info("Subscription received from: " + msg.getSenderEndpointUri());
			if(exchange.getPattern().equals(ExchangePattern.InOut)){
				exchange.setOutBoundMessage(new DefaultMessage(SubscriptionFilter.SUBSCRIBE_OK));
				InteractionHelper helper = new InteractionHelper(getEndpoint());
				helper.send(msg.getSenderEndpointUri(), exchange);
			}
		} else if (msg.getName().equals(SubscriptionFilter.UNSUBSCRIBE)) {
			subscriptions.remove(msg);
			logger.info("UnSubscription received from: " + msg.getSenderEndpointUri());
		} else if (msg.getName().equals(SubscriptionFilter.UNSUBSCRIBE_ALL)) {
			Set<Entry<Message, String>> entrySet = subscriptions.entrySet();
			for (Iterator it = entrySet.iterator(); it.hasNext();) {
				Entry<Message, String> entry = (Entry) it.next();
				if (entry.getValue().equalsIgnoreCase(msg.getSenderEndpointUri())) {
					it.remove();
				}
			}
			logger.info("UnSubscription (all filters) received from: " + msg.getSenderEndpointUri());
		} else if (msg.getName().equals(Notification.NOTIFY)) {
			Set<String> sSet = new HashSet<String>();
			for (Message filter : subscriptions.keySet()) {
				if (Covering.apply(filter, msg)) {
					sSet.add(subscriptions.get(filter));
				}
			}
			Iterator<String> iter = sSet.iterator();
			while (iter.hasNext()) {
				String uri = iter.next();
				Exchange ex = getEndpoint().createExchange(new ExchangePattern(ExchangePattern.OutOnly));
				try {
					ex.setOutBoundMessage(msg.copy());
				} catch (Exception e) {
					logger.error("Unknown Exception caught while processing exchange " + exchange, e);
				}
				InteractionHelper helper = new InteractionHelper(getEndpoint());
				helper.send(uri, ex);
			}
		}
	}
}
