/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.serialize;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.ArrayHelper;
import org.coos.util.serialize.HashtableHelper;
import org.coos.util.serialize.IntegerHelper;
import org.coos.util.serialize.StringHelper;
import org.coos.util.serialize.VectorHelper;

public class ObjectHelper {
    public static byte[] persist(Object object) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        ObjectHelper.persist(object, dout);
        return bout.toByteArray();
    }

    public static void persist(Object object, DataOutputStream dout) throws Exception {
        if (object instanceof Hashtable) {
            dout.writeByte(1);
            ((OutputStream)dout).write(HashtableHelper.persist((Hashtable)object));
        } else if (object instanceof String) {
            dout.writeByte(2);
            ((OutputStream)dout).write(StringHelper.persist((String)object));
        } else if (object instanceof Vector) {
            dout.writeByte(3);
            ((OutputStream)dout).write(VectorHelper.persist((Vector)object));
        } else if (object instanceof byte[] || object instanceof String[] || object instanceof int[]) {
            dout.writeByte(4);
            ((OutputStream)dout).write(ArrayHelper.persist(object));
        } else if (object instanceof AFSerializer) {
            dout.writeByte(5);
            if (object == null) {
                dout.writeInt(-1);
            } else {
                dout.writeUTF(object.getClass().getName());
                byte[] data = ((AFSerializer)object).serialize();
                dout.writeInt(data.length);
                if (data.length > 0) {
                    ((OutputStream)dout).write(data);
                }
            }
            dout.flush();
        } else if (object instanceof Integer) {
            dout.writeByte(6);
            IntegerHelper.persist((Integer)object, dout);
        } else {
            throw new Exception("Cannot serialize object of type " + object.getClass().getName());
        }
    }

    public static Object resurrect(DataInputStream din, AFClassLoader loader) throws Exception {
        byte type = din.readByte();
        switch (type) {
            case 1: {
                return HashtableHelper.resurrect(din, loader);
            }
            case 2: {
                return StringHelper.resurrect(din);
            }
            case 3: {
                return VectorHelper.resurrect(din, loader);
            }
            case 4: {
                return ArrayHelper.resurrect(din);
            }
            case 5: {
                Object o;
                String cname = din.readUTF();
                int len = din.readInt();
                byte[] tmp = new byte[len];
                din.readFully(tmp);
                if (loader == null) {
                    Class<?> cl = Class.forName(cname);
                    o = cl.newInstance();
                    ((AFSerializer)o).deSerialize(tmp, loader);
                } else {
                    Class cl = loader.loadClass(cname);
                    o = cl.newInstance();
                    ((AFSerializer)o).deSerialize(tmp, loader);
                }
                return o;
            }
            case 6: {
                return IntegerHelper.resurrect(din);
            }
        }
        throw new Exception("Can not resurrect object of type " + type);
    }
}

