/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.util.serialize;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * Hashtable helper for persitance and resurrection.
 * 
 * @author Geir Melby, Tellu AS
 */
public class HashtableHelper {
	/**
	 * Helper for Hashtable serialization.
	 * 
	 * @param hTable
	 * @return
	 * @throws IOException
	 */

	public static byte[] persist(Hashtable hTable) throws IOException {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		DataOutputStream dout = new DataOutputStream(bout);
		persist(hTable, dout);
		return bout.toByteArray();

	}

	public static void persist(Hashtable hTable, DataOutputStream dout) throws IOException {

		if (hTable == null) {
			dout.writeBoolean(false);
		} else {
			dout.writeBoolean(true);
			// write the vector values.
			VectorHelper.persist(getValues(hTable), dout);

			// write the key table
			Vector keys = new Vector();
			Enumeration eKeys = hTable.keys();

			while (eKeys.hasMoreElements()) {
				keys.addElement(eKeys.nextElement());
			}

			VectorHelper.persist(keys, dout);
		}

		dout.flush();

	}

	public static Hashtable resurrect(DataInputStream din, AFClassLoader cl) throws IOException {
		if (din.readBoolean()) {
			// There exists a hastable.
			Hashtable ht = new Hashtable();
			Vector values = VectorHelper.resurrect(din, cl);
			Vector keys = VectorHelper.resurrect(din, cl);

			if (keys.size() != values.size()) {
				throw (new IOException()); // should not happen.
			}

			for (int i = 0; i < keys.size(); i++) {
				// fill the hashtable
				ht.put(keys.elementAt(i), values.elementAt(i));
			}

			return ht;
		}

		return null;
	}

	private static Vector getValues(Hashtable h1) {
		Vector v1 = new Vector();
		Enumeration e = h1.elements();

		while (e.hasMoreElements()) {
			Object o = e.nextElement();
			v1.addElement(o);
		}

		return v1;
	}
}
