/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.cldc.rms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.StringHelper;

public class RMSHelper {
    public static synchronized boolean checkIfTheStoreExist(String storeName) {
        if (storeName == null) {
            return false;
        }
        String[] stores = RecordStore.listRecordStores();
        if (stores != null) {
            for (int i = 0; i < stores.length; ++i) {
                String store = stores[i];
                if (!store.equals(storeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized int getLastRecordId(String storeName) {
        if (!RMSHelper.checkIfTheStoreExist(storeName)) {
            return -1;
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            return store.getNextRecordID() - 1;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return -1;
        }
    }

    public static synchronized int getNextRecordId(String storeName) {
        if (!RMSHelper.checkIfTheStoreExist(storeName)) {
            return -1;
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            return store.getNextRecordID();
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return -1;
        }
    }

    public static synchronized void deleteStore(String storeName) {
        if (!RMSHelper.checkIfTheStoreExist(storeName)) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)storeName);
            return;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return;
        }
    }

    public static synchronized boolean loadFromStore(String storeName, int recordNumber, AFSerializer element) {
        if (element == null) {
            return false;
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            byte[] data = store.getRecord(recordNumber);
            element.deSerialize(data, null);
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static synchronized byte[] loadFromStore(String storeName, int recordNumber) {
        byte[] data = null;
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            data = store.getRecord(recordNumber);
            store.closeRecordStore();
            return data;
        }
        catch (RecordStoreException rse) {
            throw new NullPointerException("Ivalid record number <" + recordNumber + ">");
        }
    }

    public static synchronized int appendToStore(String storeName, byte[] data) {
        int no = 0;
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            no = store.addRecord(data, 0, data.length);
            store.closeRecordStore();
            return no;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return no;
        }
    }

    public static synchronized int saveToStore(String storeName, byte[] data, int recordNumber) {
        int no = 0;
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            no = store.getNextRecordID();
            if (recordNumber >= no) {
                no = store.addRecord(data, 0, data.length);
            } else {
                store.setRecord(recordNumber, data, 0, data.length);
                no = recordNumber;
            }
            store.closeRecordStore();
            return no;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return no;
        }
    }

    public static synchronized Vector loadFromStore(String storeName) {
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            RecordEnumeration re = store.enumerateRecords(null, null, false);
            int no = store.getNextRecordID();
            Vector<byte[]> v = new Vector<byte[]>(no);
            while (re.hasNextElement()) {
                byte[] data = re.nextRecord();
                v.addElement(data);
            }
            store.closeRecordStore();
            return v;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return null;
        }
    }

    public static synchronized String[] loadStringsFromStore(String storeName) {
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            RecordEnumeration re = store.enumerateRecords(null, null, false);
            int no = store.getNextRecordID();
            int i = 0;
            String[] sa = new String[no - 1];
            while (re.hasNextElement()) {
                byte[] data = re.nextRecord();
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                String s = StringHelper.resurrect(din);
                sa[i++] = s;
            }
            store.closeRecordStore();
            return sa;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static synchronized boolean saveStringsToStore(String storeName, String[] sa) {
        if (!RMSHelper.checkIfTheStoreExist(storeName)) {
            return false;
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            int j = 0;
            for (int i = sa.length; i > 0; --i) {
                String s = sa[i - 1];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                ((OutputStream)dout).write(StringHelper.persist(s));
                dout.flush();
                byte[] data = bout.toByteArray();
                if (store.getNextRecordID() <= j + 1) {
                    store.addRecord(data, 0, data.length);
                } else {
                    store.setRecord(j + 1, data, 0, data.length);
                }
                ++j;
            }
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static synchronized boolean appendStringsToStore(String storeName, String[] sa) {
        if (!RMSHelper.checkIfTheStoreExist(storeName)) {
            return false;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            for (int i = 0; i < sa.length; ++i) {
                String s = sa[i];
                ((OutputStream)dout).write(StringHelper.persist(s));
                dout.flush();
                byte[] data = bout.toByteArray();
                store.addRecord(data, 0, data.length);
            }
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static synchronized boolean saveToStore(String storeName, Vector v) {
        if (v == null) {
            return false;
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            RMSHelper.cleanStore(storeName);
            for (int i = 0; i < v.size(); ++i) {
                AFSerializer el = (AFSerializer)v.elementAt(i);
                byte[] data = el.serialize();
                if (store.getNextRecordID() <= i + 1) {
                    store.setRecord(i + 1, data, 0, data.length);
                    continue;
                }
                store.addRecord(data, 0, data.length);
            }
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static synchronized boolean appendToStore(String storeName, Vector v) {
        if (v == null) {
            return false;
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            for (int i = 0; i < v.size(); ++i) {
                AFSerializer el = (AFSerializer)v.elementAt(i);
                byte[] data = el.serialize();
                store.addRecord(data, 0, data.length);
            }
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static synchronized int appendToStore(String storeName, AFSerializer element) {
        if (element == null) {
            return 0;
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            byte[] data = element.serialize();
            int recordNo = store.getNextRecordID();
            store.addRecord(data, 0, data.length);
            store.closeRecordStore();
            return recordNo;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static synchronized int getNumberOfRecords(String storeName) {
        int reti = 0;
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)true, (int)1, (boolean)false);
            reti = store.getNumRecords();
            store.closeRecordStore();
        }
        catch (RecordStoreNotOpenException err) {
            err.printStackTrace();
        }
        catch (RecordStoreException err) {
            err.printStackTrace();
        }
        return reti;
    }

    public static synchronized boolean createStore(String storeName) {
        try {
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)true, (int)1, (boolean)false);
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return false;
        }
    }

    public static synchronized long getLastUpdated(String storeName) {
        try {
            if (!RMSHelper.checkIfTheStoreExist(storeName)) {
                return 0L;
            }
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false, (int)1, (boolean)false);
            long lastModified = store.getLastModified();
            store.closeRecordStore();
            return lastModified;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return 0L;
        }
    }

    public static synchronized boolean cleanStore(String storeName) {
        try {
            RecordStore.deleteRecordStore((String)storeName);
            RMSHelper.createStore(storeName);
            return true;
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
    }

    public static synchronized boolean removeFirstElementFromStore(String storeName, int no) {
        try {
            if (!RMSHelper.checkIfTheStoreExist(storeName)) {
                return false;
            }
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            int lnr = 0;
            RecordEnumeration e = store.enumerateRecords(null, null, false);
            while (e.hasNextElement()) {
                if (lnr++ == no) {
                    store.deleteRecord(e.nextRecordId());
                    break;
                }
                e.nextRecordId();
            }
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return false;
        }
    }

    public static synchronized boolean removeElementFromStore(String storeName, int no) {
        try {
            if (!RMSHelper.checkIfTheStoreExist(storeName)) {
                return false;
            }
            RecordStore store = RecordStore.openRecordStore((String)storeName, (boolean)false);
            store.deleteRecord(no);
            store.closeRecordStore();
            return true;
        }
        catch (RecordStoreException rse) {
            rse.printStackTrace();
            return false;
        }
    }

    public static synchronized boolean checkIfStoreIsUptoDate(String storeName, String period) {
        long p = 0L;
        if (period != null) {
            p = Integer.parseInt(period);
        }
        return RMSHelper.checkIfStoreIsUptoDate(storeName, p);
    }

    public static synchronized boolean checkIfStoreIsUptoDate(String storeName, long period) {
        long now = new Date().getTime();
        long lastUpdated = RMSHelper.getLastUpdated(storeName);
        System.out.println("Difference:" + (now - lastUpdated) / 1000L);
        return lastUpdated > now - period * 1000L;
    }
}

