/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.serialize;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.StringHelper;

public class ArrayHelper {
    public static byte[] persist(Object object) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        ArrayHelper.persist(object, dout);
        return bout.toByteArray();
    }

    public static void persist(Object object, DataOutputStream dout) throws IOException {
        if (object == null) {
            dout.writeInt(-1);
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n = stringArray.length;
            dout.writeInt(n);
            StringHelper.persist("StringArray", dout);
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                ((OutputStream)dout).write(StringHelper.persist(s));
            }
        } else if (object instanceof byte[]) {
            byte[] byteArray = (byte[])object;
            int n = byteArray.length;
            dout.writeInt(n);
            StringHelper.persist("ByteArray", dout);
            dout.write(byteArray, 0, n);
        } else if (object instanceof int[]) {
            int[] intArray = (int[])object;
            int n = intArray.length;
            dout.writeInt(n);
            StringHelper.persist("IntArray", dout);
            for (int i = 0; i < intArray.length; ++i) {
                int data = intArray[i];
                dout.writeInt(data);
            }
        } else if (object instanceof AFSerializer[]) {
            AFSerializer[] afArray = (AFSerializer[])object;
            int n = afArray.length;
            dout.writeInt(n);
            StringHelper.persist("AFArray", dout);
            for (int i = 0; i < n; ++i) {
                AFSerializer obj = afArray[i];
                if (obj == null) {
                    dout.writeUTF("null");
                    continue;
                }
                dout.writeUTF(obj.getClass().getName());
                byte[] data = obj.serialize();
                dout.writeInt(data.length);
                if (data.length <= 0) continue;
                ((OutputStream)dout).write(data);
            }
        }
        dout.flush();
    }

    public static Object resurrect(DataInputStream din) throws IOException {
        Object[] result = null;
        int n = din.readInt();
        if (n != -1) {
            String s = StringHelper.resurrect(din);
            if (s.equals("StringArray")) {
                String[] stringArray = null;
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String sin;
                    stringArray[i] = sin = StringHelper.resurrect(din);
                }
                result = stringArray;
            } else if (s.equals("ByteArray")) {
                byte[] byteArray = new byte[n];
                din.readFully(byteArray, 0, n);
                result = byteArray;
            } else if (s.equals("IntArray")) {
                int[] intArray = new int[n];
                for (int i = 0; i < intArray.length; ++i) {
                    intArray[i] = din.readInt();
                }
                result = intArray;
            }
        }
        return result;
    }

    public static Object resurrect(DataInputStream din, AFClassLoader loader) throws IOException {
        Object[] result = null;
        int n = din.readInt();
        if (n != -1) {
            String s = StringHelper.resurrect(din);
            if (s.equals("StringArray")) {
                String[] stringArray = null;
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String sin;
                    stringArray[i] = sin = StringHelper.resurrect(din);
                }
                result = stringArray;
            } else if (s.equals("ByteArray")) {
                byte[] byteArray = new byte[n];
                din.readFully(byteArray, 0, n);
                result = byteArray;
            } else if (s.equals("IntArray")) {
                int[] intArray = new int[n];
                for (int i = 0; i < intArray.length; ++i) {
                    intArray[i] = din.readInt();
                }
                result = intArray;
            } else if (s.equals("AFArray")) {
                AFSerializer[] afArray = new AFSerializer[n];
                for (int i = 0; i < n; ++i) {
                    String cname = din.readUTF();
                    if (cname.equals("null")) {
                        afArray[i] = null;
                        continue;
                    }
                    int len = din.readInt();
                    byte[] tmp = new byte[len];
                    din.readFully(tmp);
                    try {
                        AFSerializer obj;
                        Class cl;
                        if (loader == null) {
                            cl = Class.forName(cname);
                            obj = (AFSerializer)cl.newInstance();
                            obj.deSerialize(tmp, loader);
                        } else {
                            cl = loader.loadClass(cname);
                            obj = (AFSerializer)cl.newInstance();
                            obj.deSerialize(tmp, loader);
                        }
                        afArray[i] = obj;
                        continue;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IOException("Exception " + e.toString());
                    }
                }
                result = afArray;
            }
        }
        return result;
    }
}

