/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IntegerHelper {
    public static byte[] persist(Integer i) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        IntegerHelper.persist(i, dout);
        return bout.toByteArray();
    }

    public static void persist(Integer i, DataOutputStream dout) throws IOException {
        if (i == null) {
            dout.writeBoolean(false);
        } else {
            dout.writeBoolean(true);
            dout.writeInt(i);
        }
        dout.flush();
    }

    public static Integer resurrect(DataInputStream din) throws IOException {
        if (din.readBoolean()) {
            return new Integer(din.readInt());
        }
        return null;
    }

    public static Integer resurrect(byte[] data) throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));
        return IntegerHelper.resurrect(din);
    }
}

