/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.macro;

import java.util.HashMap;
import java.util.Map;
import org.coos.util.macro.MacroUtilityException;

public class MacroSubstituter {
    private Map<String, String> properties = null;
    private Map<String, String> foundMacros = new HashMap<String, String>();
    private boolean dryRun = false;
    private int unresolved = 0;

    public MacroSubstituter() {
    }

    public MacroSubstituter(Map<String, String> defaultProperties) {
        this.setDefaultProperties(defaultProperties);
    }

    public Map<String, String> getFoundMacros() {
        return this.foundMacros;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public int getUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(int unresolved) {
        this.unresolved = unresolved;
    }

    public Map<String, String> getDefaultProperties() {
        return this.properties;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.properties = new HashMap<String, String>(defaultProperties);
    }

    public String process(String s) {
        return this.process(s, false);
    }

    public String process(String s, boolean makeTemplate) {
        StringBuilder b = null;
        int pos = 0;
        if (!this.isDryRun()) {
            b = new StringBuilder();
        }
        while (pos < s.length()) {
            int index0 = s.indexOf("${", pos);
            if (index0 >= pos) {
                if (!this.isDryRun()) {
                    b.append(s.substring(pos, index0));
                }
                int index1 = -1;
                int temp = index0;
                while (index1 < 0 && temp < s.length()) {
                    index1 = s.indexOf("}", temp);
                    if (index1 > temp) {
                        if (s.charAt(index1 - 1) != '\\') continue;
                        temp = index1 + 1;
                        index1 = -1;
                        continue;
                    }
                    temp = s.length();
                }
                if (index1 < 0) {
                    throw new MacroUtilityException("Could not find maching macro end-token, near <" + s.substring(index0, Math.min(s.length(), index0 + 10)) + ">");
                }
                pos = index1 + 1;
                String key = s.substring(index0 += "${".length(), (index1 -= "}".length()) + 1);
                String value = this.processMacro(key);
                if (this.isDryRun()) continue;
                if (value != null) {
                    if (makeTemplate) {
                        b.append("${");
                        int keyKeyPos = key.indexOf(":");
                        if (keyKeyPos >= 0) {
                            b.append(key.substring(0, keyKeyPos));
                        } else {
                            b.append(key);
                        }
                        b.append(":-");
                    }
                    b.append(value);
                    if (!makeTemplate) continue;
                    b.append("}");
                    continue;
                }
                b.append("${");
                b.append(key);
                b.append("}");
                continue;
            }
            if (!this.isDryRun()) {
                b.append(s.substring(pos, s.length()));
            }
            pos = s.length();
        }
        if (this.isDryRun()) {
            return s;
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processMacro(String macro) {
        String value = null;
        String att = null;
        String key = macro;
        String cmd = null;
        int index = macro.indexOf(":");
        if (index >= 0) {
            cmd = macro.substring(index, index + 2);
            key = macro.substring(0, index);
            att = macro.substring(index + 2);
            att = att == null ? "" : this.stripEscapeChars(att);
        }
        if ((value = this.getProperty(key)) == null) {
            if (cmd != null) {
                if (cmd.equals(":=")) {
                    this.putProperty(key, att);
                    value = att;
                    this.foundMacros.put(key, value);
                    return value;
                } else {
                    if (!cmd.equals(":-")) throw new MacroUtilityException("Macro substitution for expression ${macro-name" + cmd + "defval} not implemented");
                    value = att;
                    if (this.foundMacros.containsKey(key)) return value;
                    this.foundMacros.put(key, value);
                }
                return value;
            } else {
                ++this.unresolved;
                this.foundMacros.put(key, null);
            }
            return value;
        } else {
            this.foundMacros.put(key, value);
        }
        return value;
    }

    protected String stripEscapeChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                // empty if block
            }
            int n = ++i;
            sb.append(s.charAt(n));
        }
        return sb.toString();
    }

    private String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    private void putProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public void clear() {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.foundMacros.clear();
        this.unresolved = 0;
    }
}

