/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StringHelper {
    public static byte[] persist(String str) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        StringHelper.persist(str, dout);
        return bout.toByteArray();
    }

    public static void persist(String str, DataOutputStream dout) throws IOException {
        if (str == null) {
            dout.writeBoolean(false);
        } else {
            dout.writeBoolean(true);
            dout.writeUTF(str);
        }
        dout.flush();
    }

    public static String resurrect(DataInputStream din) throws IOException {
        if (din.readBoolean()) {
            return din.readUTF();
        }
        return null;
    }

    public static String resurrect(byte[] data) throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));
        if (din.readBoolean()) {
            return din.readUTF();
        }
        return null;
    }
}

