/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.serialize;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.util.serialize.HashtableHelper;

public class VectorHelper {
    public static final int NULL = 0;
    public static final int INTEGER = 1;
    public static final int STRING = 2;
    public static final int LONG = 3;
    public static final int BOOLEAN = 4;
    public static final int AFSERIALIZABLE = 5;
    public static final int VECTOR = 6;
    public static final int HASHTABLE = 7;
    public static final int BYTEARRAY = 8;
    public static final int FLOAT = 9;
    public static final int STRINGARRAY = 10;
    public static final int DOUBLE = 11;
    public static final int DOUBLEARRAY = 12;

    public static byte[] persist(Vector v) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        VectorHelper.persist(v, dout);
        return bout.toByteArray();
    }

    public static void persist(Vector v, DataOutputStream dout) throws IOException {
        if (v == null) {
            dout.writeInt(-1);
        } else {
            int n = v.size();
            dout.writeInt(n);
            for (int i = 0; i < n; ++i) {
                int x;
                Object[] tmp;
                Object o = v.elementAt(i);
                if (o instanceof String) {
                    dout.writeByte(2);
                    dout.writeUTF((String)o);
                    continue;
                }
                if (o instanceof Integer) {
                    dout.writeByte(1);
                    dout.writeInt((Integer)o);
                    continue;
                }
                if (o instanceof Double) {
                    dout.writeByte(11);
                    dout.writeDouble((Double)o);
                    continue;
                }
                if (o instanceof Long) {
                    dout.writeByte(3);
                    dout.writeLong((Long)o);
                    continue;
                }
                if (o instanceof Float) {
                    dout.writeFloat(9.0f);
                    dout.writeFloat(((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Boolean) {
                    dout.writeByte(4);
                    dout.writeBoolean((Boolean)o);
                    continue;
                }
                if (o instanceof Vector) {
                    dout.writeByte(6);
                    VectorHelper.persist((Vector)o, dout);
                    continue;
                }
                if (o instanceof Hashtable) {
                    dout.writeByte(7);
                    HashtableHelper.persist((Hashtable)o, dout);
                    continue;
                }
                if (o instanceof AFSerializer) {
                    dout.writeByte(5);
                    dout.writeUTF(o.getClass().getName());
                    byte[] data = ((AFSerializer)o).serialize();
                    dout.writeInt(data.length);
                    if (data.length <= 0) continue;
                    dout.write(data);
                    continue;
                }
                if (o instanceof byte[]) {
                    dout.writeByte(8);
                    dout.writeInt(((byte[])o).length);
                    dout.write((byte[])o);
                    continue;
                }
                if (o instanceof String[]) {
                    dout.writeByte(10);
                    tmp = (String[])o;
                    dout.writeInt(tmp.length);
                    for (x = 0; x < tmp.length; ++x) {
                        dout.writeUTF(tmp[x]);
                    }
                    continue;
                }
                if (o instanceof double[]) {
                    dout.writeByte(12);
                    tmp = (double[])o;
                    dout.writeInt(tmp.length);
                    for (x = 0; x < tmp.length; ++x) {
                        dout.writeDouble((double)tmp[x]);
                    }
                    continue;
                }
                if (o == null) {
                    dout.writeByte(0);
                    continue;
                }
                throw new IOException("Cannot persist object of type " + o.getClass().getName());
            }
        }
        dout.flush();
    }

    public static Vector resurrect(DataInputStream din, AFClassLoader loader) throws IOException {
        Vector<Object> v = new Vector<Object>();
        int n = din.readInt();
        if (n == -1) {
            v = null;
        } else {
            for (int i = 0; i < n; ++i) {
                byte type = din.readByte();
                if (type == 0) {
                    v.addElement(null);
                    continue;
                }
                if (type == 1) {
                    v.addElement(new Integer(din.readInt()));
                    continue;
                }
                if (type == 11) {
                    v.addElement(new Double(din.readDouble()));
                    continue;
                }
                if (type == 2) {
                    v.addElement(din.readUTF());
                    continue;
                }
                if (type == 3) {
                    v.addElement(new Long(din.readLong()));
                    continue;
                }
                if (type == 9) {
                    v.addElement(new Float(din.readFloat()));
                    continue;
                }
                if (type == 4) {
                    v.addElement(new Boolean(din.readBoolean()));
                    continue;
                }
                if (type == 6) {
                    v.addElement(VectorHelper.resurrect(din, loader));
                    continue;
                }
                if (type == 7) {
                    v.addElement(HashtableHelper.resurrect(din, loader));
                    continue;
                }
                if (type == 5) {
                    String cname = din.readUTF();
                    int len = din.readInt();
                    byte[] tmp = new byte[len];
                    din.readFully(tmp);
                    try {
                        Object o;
                        Class cl;
                        if (loader == null) {
                            cl = Class.forName(cname);
                            o = cl.newInstance();
                            ((AFSerializer)o).deSerialize(tmp, loader);
                        } else {
                            cl = loader.loadClass(cname);
                            o = cl.newInstance();
                            ((AFSerializer)o).deSerialize(tmp, loader);
                        }
                        v.addElement(o);
                        continue;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IOException("Exception " + e.toString());
                    }
                }
                if (type == 8) {
                    byte[] ba = new byte[din.readInt()];
                    din.readFully(ba);
                    v.addElement(ba);
                    continue;
                }
                if (type == 10) {
                    String[] st = new String[din.readInt()];
                    for (int x = 0; x < st.length; ++x) {
                        st[x] = din.readUTF();
                    }
                    v.addElement(st);
                    continue;
                }
                if (type == 12) {
                    int length = din.readInt();
                    double[] tmp = new double[length];
                    for (int x = 0; x < length; ++x) {
                        tmp[x] = din.readDouble();
                    }
                    v.addElement(tmp);
                    continue;
                }
                throw new IOException("Unknown type " + type);
            }
        }
        return v;
    }
}

