/*
 * Decompiled with CFR 0.152.
 */
package org.coos.util.macro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.coos.util.macro.MacroSubstituter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroSubstituteReader
extends BufferedReader {
    private MacroSubstituter macroSubstituter;

    public MacroSubstituteReader(Reader in, Map<String, String> defaultProperties) {
        super(in);
        this.macroSubstituter = new MacroSubstituter(defaultProperties);
    }

    public MacroSubstituteReader(Reader in) {
        super(in);
        this.macroSubstituter = new MacroSubstituter();
    }

    @Override
    public int read() throws IOException {
        throw new IOException("read() not supported");
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new IOException("read(char[] cbuf, int off, int len) not supported");
    }

    @Override
    public String readLine() throws IOException {
        String s = super.readLine();
        if (s != null) {
            return this.macroSubstituter.process(s);
        }
        return s;
    }

    public Map<String, String> scanForMacrosOnly() throws IOException {
        this.macroSubstituter.setDryRun(true);
        String s = this.readLine();
        while (s != null) {
            s = this.readLine();
        }
        return this.macroSubstituter.getFoundMacros();
    }

    public String substituteMacros() throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        this.macroSubstituter.setDryRun(false);
        while ((s = this.readLine()) != null) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public Map<String, String> getFoundMacros() {
        return this.macroSubstituter.getFoundMacros();
    }
}

