/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.ext.persistent;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.copperengine.core.DependencyInjector;
import org.copperengine.core.EngineIdProvider;
import org.copperengine.core.EngineIdProviderBean;
import org.copperengine.core.common.DefaultProcessorPoolManager;
import org.copperengine.core.common.IdFactory;
import org.copperengine.core.common.JdkRandomUUIDFactory;
import org.copperengine.core.common.ProcessorPoolManager;
import org.copperengine.core.common.WorkflowRepository;
import org.copperengine.core.monitoring.LoggingStatisticCollector;
import org.copperengine.core.persistent.PersistentPriorityProcessorPool;
import org.copperengine.core.persistent.PersistentProcessorPool;
import org.copperengine.core.persistent.PersistentScottyEngine;
import org.copperengine.core.persistent.ScottyDBStorageInterface;
import org.copperengine.core.persistent.Serializer;
import org.copperengine.core.persistent.StandardJavaSerializer;
import org.copperengine.core.persistent.txn.TransactionController;
import org.copperengine.ext.wfrepo.classpath.ClasspathWorkflowRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentEngineFactory<T extends DependencyInjector> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPersistentEngineFactory.class);
    private int statLoggerIntervalSeconds = 60;
    private String engineId = "default";
    private List<String> wfPackges;
    protected final Supplier<PersistentScottyEngine> engine;
    protected final Supplier<ExecutorService> executorService;
    protected final Supplier<LoggingStatisticCollector> statisticCollector;
    protected final Supplier<WorkflowRepository> workflowRepository;
    protected final Supplier<Serializer> serializer;
    protected final Supplier<T> dependencyInjector;
    protected final Supplier<EngineIdProvider> engineIdProvider;
    protected final Supplier<IdFactory> idFactory;
    protected final Supplier<ProcessorPoolManager<PersistentProcessorPool>> processorPoolManager;
    protected final Supplier<ScottyDBStorageInterface> dbStorage;
    protected final Supplier<TransactionController> transactionController;

    public AbstractPersistentEngineFactory(List<String> wfPackges) {
        this.wfPackges = wfPackges;
        this.processorPoolManager = Suppliers.memoize((Supplier)new Supplier<ProcessorPoolManager<PersistentProcessorPool>>(){

            public ProcessorPoolManager<PersistentProcessorPool> get() {
                logger.info("Creating ProcessorPoolManager...");
                return AbstractPersistentEngineFactory.this.createProcessorPoolManager();
            }
        });
        this.dbStorage = Suppliers.memoize((Supplier)new Supplier<ScottyDBStorageInterface>(){

            public ScottyDBStorageInterface get() {
                logger.info("Creating DBStorage...");
                return AbstractPersistentEngineFactory.this.createDBStorage();
            }
        });
        this.executorService = Suppliers.memoize((Supplier)new Supplier<ExecutorService>(){

            public ExecutorService get() {
                logger.info("Creating ExecutorService...");
                return AbstractPersistentEngineFactory.this.createExecutorService();
            }
        });
        this.statisticCollector = Suppliers.memoize((Supplier)new Supplier<LoggingStatisticCollector>(){

            public LoggingStatisticCollector get() {
                logger.info("Creating LoggingStatisticCollector...");
                return AbstractPersistentEngineFactory.this.createStatisticsLogger();
            }
        });
        this.workflowRepository = Suppliers.memoize((Supplier)new Supplier<WorkflowRepository>(){

            public WorkflowRepository get() {
                logger.info("Creating WorkflowRepository...");
                return AbstractPersistentEngineFactory.this.createWorkflowRepository();
            }
        });
        this.serializer = Suppliers.memoize((Supplier)new Supplier<Serializer>(){

            public Serializer get() {
                logger.info("Creating Serializer...");
                return AbstractPersistentEngineFactory.this.createSerializer();
            }
        });
        this.engine = Suppliers.memoize((Supplier)new Supplier<PersistentScottyEngine>(){

            public PersistentScottyEngine get() {
                logger.info("Creating PersistentScottyEngine...");
                return AbstractPersistentEngineFactory.this.createPersistentScottyEngine();
            }
        });
        this.dependencyInjector = Suppliers.memoize((Supplier)new Supplier<T>(){

            public T get() {
                logger.info("Creating DependencyInjector...");
                return AbstractPersistentEngineFactory.this.createDependencyInjector();
            }
        });
        this.engineIdProvider = Suppliers.memoize((Supplier)new Supplier<EngineIdProvider>(){

            public EngineIdProvider get() {
                logger.info("Creating EngineIdProvider...");
                return AbstractPersistentEngineFactory.this.createEngineIdProvider();
            }
        });
        this.idFactory = Suppliers.memoize((Supplier)new Supplier<IdFactory>(){

            public IdFactory get() {
                logger.info("Creating IdFactory...");
                return AbstractPersistentEngineFactory.this.createIdFactory();
            }
        });
        this.transactionController = Suppliers.memoize((Supplier)new Supplier<TransactionController>(){

            public TransactionController get() {
                logger.info("Creating TransactionController...");
                return AbstractPersistentEngineFactory.this.createTransactionController();
            }
        });
    }

    protected abstract TransactionController createTransactionController();

    protected abstract ScottyDBStorageInterface createDBStorage();

    protected abstract T createDependencyInjector();

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public void setStatLoggerIntervalSeconds(int statLoggerIntervalSeconds) {
        this.statLoggerIntervalSeconds = statLoggerIntervalSeconds;
    }

    protected int getStatLoggerIntervalSeconds() {
        return this.statLoggerIntervalSeconds;
    }

    protected ProcessorPoolManager<PersistentProcessorPool> createProcessorPoolManager() {
        PersistentPriorityProcessorPool ppool = new PersistentPriorityProcessorPool("P#DEFAULT", (TransactionController)this.transactionController.get(), Runtime.getRuntime().availableProcessors());
        ppool.setEmptyQueueWaitMSec(2);
        ppool.setDequeueBulkSize(50);
        ArrayList<PersistentPriorityProcessorPool> pools = new ArrayList<PersistentPriorityProcessorPool>();
        pools.add(ppool);
        DefaultProcessorPoolManager processorPoolManager = new DefaultProcessorPoolManager();
        processorPoolManager.setProcessorPools(pools);
        return processorPoolManager;
    }

    protected IdFactory createIdFactory() {
        return new JdkRandomUUIDFactory();
    }

    protected EngineIdProvider createEngineIdProvider() {
        return new EngineIdProviderBean(this.engineId);
    }

    protected PersistentScottyEngine createPersistentScottyEngine() {
        PersistentScottyEngine engine = new PersistentScottyEngine();
        engine.setDbStorage((ScottyDBStorageInterface)this.dbStorage.get());
        engine.setWfRepository((WorkflowRepository)this.workflowRepository.get());
        engine.setEngineIdProvider((EngineIdProvider)this.engineIdProvider.get());
        engine.setIdFactory((IdFactory)this.idFactory.get());
        engine.setProcessorPoolManager((ProcessorPoolManager)this.processorPoolManager.get());
        engine.setDependencyInjector((DependencyInjector)this.dependencyInjector.get());
        return engine;
    }

    protected Serializer createSerializer() {
        return new StandardJavaSerializer();
    }

    protected WorkflowRepository createWorkflowRepository() {
        return new ClasspathWorkflowRepository(this.wfPackges);
    }

    protected ExecutorService createExecutorService() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    protected LoggingStatisticCollector createStatisticsLogger() {
        LoggingStatisticCollector statisticCollector = new LoggingStatisticCollector();
        statisticCollector.setLoggingIntervalSec(this.statLoggerIntervalSeconds);
        statisticCollector.start();
        return statisticCollector;
    }

    public void destroyEngine() {
        ((PersistentScottyEngine)this.engine.get()).shutdown();
        ((ExecutorService)this.executorService.get()).shutdown();
        ((LoggingStatisticCollector)this.statisticCollector.get()).shutdown();
    }

    public PersistentScottyEngine getEngine() {
        return (PersistentScottyEngine)this.engine.get();
    }

    public DependencyInjector getDependencyInjector() {
        return (DependencyInjector)this.dependencyInjector.get();
    }
}

