/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.ext.persistent;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.copperengine.core.CopperRuntimeException;
import org.copperengine.core.DependencyInjector;
import org.copperengine.core.EngineIdProvider;
import org.copperengine.core.batcher.BatchRunner;
import org.copperengine.core.batcher.Batcher;
import org.copperengine.core.batcher.RetryingTxnBatchRunner;
import org.copperengine.core.batcher.impl.BatcherImpl;
import org.copperengine.core.common.WorkflowRepository;
import org.copperengine.core.persistent.DatabaseDialect;
import org.copperengine.core.persistent.DerbyDbDialect;
import org.copperengine.core.persistent.H2Dialect;
import org.copperengine.core.persistent.MySqlDialect;
import org.copperengine.core.persistent.OracleDialect;
import org.copperengine.core.persistent.OracleSimpleDialect;
import org.copperengine.core.persistent.PostgreSQLDialect;
import org.copperengine.core.persistent.ScottyDBStorage;
import org.copperengine.core.persistent.ScottyDBStorageInterface;
import org.copperengine.core.persistent.txn.CopperTransactionController;
import org.copperengine.core.persistent.txn.TransactionController;
import org.copperengine.ext.persistent.AbstractPersistentEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RdbmsEngineFactory<T extends DependencyInjector>
extends AbstractPersistentEngineFactory<T> {
    private static final Logger logger = LoggerFactory.getLogger(RdbmsEngineFactory.class);
    protected final Supplier<DataSource> dataSource = Suppliers.memoize((Supplier)new Supplier<DataSource>(){

        public DataSource get() {
            logger.info("Creating DataSource...");
            return RdbmsEngineFactory.this.createDataSource();
        }
    });
    protected final Supplier<BatcherImpl> batcher = Suppliers.memoize((Supplier)new Supplier<BatcherImpl>(){

        public BatcherImpl get() {
            logger.info("Creating Batcher...");
            return RdbmsEngineFactory.this.createBatcher();
        }
    });
    private int numberOfBatcherThreads = 4;

    public RdbmsEngineFactory(List<String> wfPackges) {
        super(wfPackges);
    }

    public void setNumberOfBatcherThreads(int numberOfBatcherThreads) {
        this.numberOfBatcherThreads = numberOfBatcherThreads;
    }

    protected abstract DataSource createDataSource();

    protected BatcherImpl createBatcher() {
        RetryingTxnBatchRunner batchRunner = new RetryingTxnBatchRunner();
        batchRunner.setDataSource((DataSource)this.dataSource.get());
        BatcherImpl batcher = new BatcherImpl(this.numberOfBatcherThreads);
        batcher.setBatchRunner((BatchRunner)batchRunner);
        batcher.startup();
        return batcher;
    }

    @Override
    protected TransactionController createTransactionController() {
        CopperTransactionController txnController = new CopperTransactionController();
        txnController.setDataSource((DataSource)this.dataSource.get());
        return txnController;
    }

    @Override
    protected ScottyDBStorageInterface createDBStorage() {
        DatabaseDialect dialect = this.createDatabaseDialect();
        ScottyDBStorage dbStorage = new ScottyDBStorage();
        dbStorage.setDialect(dialect);
        dbStorage.setTransactionController((TransactionController)this.transactionController.get());
        dbStorage.setBatcher((Batcher)this.batcher.get());
        return dbStorage;
    }

    protected DatabaseDialect createDatabaseDialect() {
        DatabaseDialect dialect = this.createDialect((DataSource)this.dataSource.get(), (WorkflowRepository)this.workflowRepository.get(), (EngineIdProvider)this.engineIdProvider.get());
        dialect.startup();
        return dialect;
    }

    protected DatabaseDialect createDialect(DataSource ds, WorkflowRepository wfRepository, EngineIdProvider engineIdProvider) {
        Connection c = null;
        try {
            c = ds.getConnection();
            String name = c.getMetaData().getDatabaseProductName();
            if ("oracle".equalsIgnoreCase(name)) {
                if (OracleDialect.schemaMatches((Connection)c)) {
                    OracleDialect dialect = new OracleDialect();
                    dialect.setWfRepository(wfRepository);
                    dialect.setEngineIdProvider(engineIdProvider);
                    dialect.setMultiEngineMode(false);
                    OracleDialect oracleDialect = dialect;
                    return oracleDialect;
                }
                OracleSimpleDialect dialect = new OracleSimpleDialect();
                dialect.setWfRepository(wfRepository);
                OracleSimpleDialect oracleSimpleDialect = dialect;
                return oracleSimpleDialect;
            }
            if ("Apache Derby".equalsIgnoreCase(name)) {
                DerbyDbDialect dialect = new DerbyDbDialect();
                dialect.setDataSource(ds);
                dialect.setWfRepository(wfRepository);
                DerbyDbDialect derbyDbDialect = dialect;
                return derbyDbDialect;
            }
            if ("H2".equalsIgnoreCase(name)) {
                H2Dialect dialect = new H2Dialect();
                dialect.setDataSource(ds);
                dialect.setWfRepository(wfRepository);
                H2Dialect h2Dialect = dialect;
                return h2Dialect;
            }
            if ("MySQL".equalsIgnoreCase(name)) {
                MySqlDialect dialect = new MySqlDialect();
                dialect.setWfRepository(wfRepository);
                MySqlDialect mySqlDialect = dialect;
                return mySqlDialect;
            }
            if ("PostgreSQL".equalsIgnoreCase(name)) {
                PostgreSQLDialect dialect = new PostgreSQLDialect();
                dialect.setWfRepository(wfRepository);
                PostgreSQLDialect postgreSQLDialect = dialect;
                return postgreSQLDialect;
            }
            try {
                throw new Error("No dialect available for DBMS " + name);
            }
            catch (Exception e) {
                throw new CopperRuntimeException("Unable to create dialect", (Throwable)e);
            }
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    logger.error("unable to close connection", (Throwable)e);
                }
            }
        }
    }

    public Batcher getBatcher() {
        return (Batcher)this.batcher.get();
    }

    @Override
    public void destroyEngine() {
        super.destroyEngine();
        ((BatcherImpl)this.batcher.get()).shutdown();
    }
}

