/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.ext.wfrepo.classpath;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.copperengine.core.WorkflowDescription;
import org.copperengine.core.WorkflowVersion;
import org.copperengine.core.common.WorkflowRepository;
import org.copperengine.core.instrument.ClassInfo;
import org.copperengine.core.instrument.ScottyFindInterruptableMethodsVisitor;
import org.copperengine.core.wfrepo.AbstractWorkflowRepository;
import org.copperengine.core.wfrepo.Clazz;
import org.copperengine.management.FileBasedWorkflowRepositoryMXBean;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathWorkflowRepository
extends AbstractWorkflowRepository
implements WorkflowRepository,
FileBasedWorkflowRepositoryMXBean {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathWorkflowRepository.class);
    private final List<String> wfPackages;
    private File adaptedTargetDir;
    private AbstractWorkflowRepository.VolatileState volatileState;

    public ClasspathWorkflowRepository(String wfPackage) {
        this(Collections.singletonList(wfPackage));
    }

    public ClasspathWorkflowRepository(List<String> wfPackages) {
        this.wfPackages = new ArrayList<String>(wfPackages);
    }

    public synchronized void start() {
        try {
            if (this.adaptedTargetDir != null) {
                return;
            }
            logger.info("Starting up with wfPackages={}", this.wfPackages);
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            this.adaptedTargetDir = new File(System.getProperty("java.io.tmpdir") + "/cpwfrepo" + System.currentTimeMillis());
            logger.info("adaptedTargetDir={}", (Object)this.adaptedTargetDir);
            this.adaptedTargetDir.mkdirs();
            Set<Class<?>> wfSet = ClasspathWorkflowRepository.findWorkflowClasses(this.wfPackages, tcl);
            wfSet.addAll(ClasspathWorkflowRepository.findWorkflowClasses(this.wfPackages, ClassLoader.getSystemClassLoader()));
            logger.info("wfSet.size={}", (Object)wfSet.size());
            Map<String, Clazz> clazzMap = this.findInterruptableMethods(wfSet, tcl);
            HashMap classInfos = new HashMap();
            this.instrumentWorkflows(this.adaptedTargetDir, clazzMap, classInfos, tcl);
            for (Clazz clazz : clazzMap.values()) {
                ClassInfo info = (ClassInfo)classInfos.get(clazz.classname);
                if (info == null) continue;
                ClassInfo superClassInfo = (ClassInfo)classInfos.get(clazz.superClassname);
                info.setSuperClassInfo(superClassInfo);
            }
            HashMap map = new HashMap();
            ClassLoader cl = super.createClassLoader(map, this.adaptedTargetDir, this.adaptedTargetDir, clazzMap);
            this.checkConstraints(map);
            HashMap wfClassMap = new HashMap(map);
            HashMap<String, Class> wfMapLatest = new HashMap<String, Class>(map.size());
            HashMap<String, Class> wfMapVersioned = new HashMap<String, Class>(map.size());
            HashMap<String, WorkflowVersion> latest = new HashMap<String, WorkflowVersion>(map.size());
            HashMap<String, ArrayList<WorkflowVersion>> versions = new HashMap<String, ArrayList<WorkflowVersion>>();
            for (Class clazz : map.values()) {
                ArrayList<WorkflowVersion> versionsList;
                wfMapLatest.put(clazz.getName(), clazz);
                WorkflowDescription wfDesc = clazz.getAnnotation(WorkflowDescription.class);
                if (wfDesc == null) continue;
                String alias = wfDesc.alias();
                WorkflowVersion version = new WorkflowVersion(wfDesc.majorVersion(), wfDesc.minorVersion(), wfDesc.patchLevelVersion());
                wfMapVersioned.put(this.createAliasName(alias, version), clazz);
                WorkflowVersion existingLatest = (WorkflowVersion)latest.get(alias);
                if (existingLatest == null || version.isLargerThan(existingLatest)) {
                    wfMapLatest.put(alias, clazz);
                    latest.put(alias, version);
                }
                if ((versionsList = (ArrayList<WorkflowVersion>)versions.get(alias)) == null) {
                    versionsList = new ArrayList<WorkflowVersion>();
                    versions.put(alias, versionsList);
                }
                versionsList.add(version);
            }
            for (List list : versions.values()) {
                Collections.sort(list, new WorkflowVersion.Comparator());
            }
            if (logger.isTraceEnabled()) {
                for (Map.Entry entry : wfMapLatest.entrySet()) {
                    logger.trace("wfMapLatest.key={}, class={}", entry.getKey(), (Object)((Class)entry.getValue()).getName());
                }
                for (Map.Entry entry : wfMapVersioned.entrySet()) {
                    logger.trace("wfMapVersioned.key={}, class={}", entry.getKey(), (Object)((Class)entry.getValue()).getName());
                }
            }
            this.volatileState = new AbstractWorkflowRepository.VolatileState(wfMapLatest, wfMapVersioned, versions, cl, 0L, wfClassMap, Collections.emptyMap(), classInfos, ClasspathWorkflowRepository.createWorkflowClassInfoMap(wfMapLatest, Collections.emptyMap()));
            logger.info("Startup finished");
        }
        catch (Exception e) {
            logger.error("startup failed", (Throwable)e);
            throw new Error("Startup failed", e);
        }
    }

    public synchronized void shutdown() {
        try {
            if (this.adaptedTargetDir != null) {
                FileUtils.deleteDirectory((File)this.adaptedTargetDir);
                this.adaptedTargetDir = null;
            }
        }
        catch (IOException e) {
            logger.warn("Unable to delete directory {}", (Object)this.adaptedTargetDir);
        }
    }

    static Set<Class<?>> findWorkflowClasses(List<String> wfPackages, ClassLoader cl) throws Exception {
        ClassPath cp = ClassPath.from((ClassLoader)cl);
        HashSet set = new HashSet();
        for (String wfPackage : wfPackages) {
            ImmutableSet x = cp.getTopLevelClassesRecursive(wfPackage);
            for (ClassPath.ClassInfo ci : x) {
                Class<?> c = cl.loadClass(ci.getName());
                set.add(c);
                set.addAll(Arrays.asList(c.getDeclaredClasses()));
                ClasspathWorkflowRepository.loadAnonymousInnerClasses(cl, set, c);
            }
        }
        return set;
    }

    private static void loadAnonymousInnerClasses(ClassLoader cl, Set<Class<?>> set, Class<?> c) {
        try {
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                String anonymousInnerclassName = c.getName() + "$" + i;
                set.add(cl.loadClass(anonymousInnerclassName));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Clazz> findInterruptableMethods(Set<Class<?>> wfSet, ClassLoader cl) throws IOException {
        logger.info("Analysing classfiles");
        HashMap<String, Clazz> clazzMap = new HashMap<String, Clazz>();
        for (Class<?> c : wfSet) {
            logger.info("analysing class {}", (Object)c.getName());
            ScottyFindInterruptableMethodsVisitor visitor = new ScottyFindInterruptableMethodsVisitor();
            URL url = cl.getResource(c.getName().replace(".", "/") + ".class");
            try (InputStream is = url.openStream();){
                ClassReader cr = new ClassReader(is);
                cr.accept((ClassVisitor)visitor, 0);
            }
            Clazz clazz = new Clazz();
            clazz.interruptableMethods = visitor.getInterruptableMethods();
            clazz.classfile = url;
            clazz.classname = visitor.getClassname();
            clazz.superClassname = visitor.getSuperClassname();
            clazzMap.put(clazz.classname, clazz);
        }
        ArrayList allClassNames = new ArrayList(clazzMap.keySet());
        for (String classname : allClassNames) {
            Clazz clazz;
            Clazz startClazz = clazz = (Clazz)clazzMap.get(classname);
            do {
                startClazz.aggregatedInterruptableMethods.addAll(clazz.interruptableMethods);
            } while (!"org/copperengine/core/Workflow".equals(clazz.superClassname) && !"org/copperengine/core/persistent/PersistentWorkflow".equals(clazz.superClassname) && (clazz = (Clazz)clazzMap.get(clazz.superClassname)) != null);
            if (clazz != null) continue;
            clazzMap.remove(classname);
            URL url = cl.getResource(classname.replace(".", "/") + ".class");
            File target = new File(this.adaptedTargetDir, classname.replace(".", "/") + ".class");
            target.getParentFile().mkdirs();
            FileUtils.copyURLToFile((URL)url, (File)target);
        }
        return clazzMap;
    }

    public String getDescription() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public List<String> getSourceDirs() {
        return Collections.emptyList();
    }

    public List<String> getSourceArchiveUrls() {
        return Collections.emptyList();
    }

    public String getLastBuildResults() {
        return null;
    }

    protected AbstractWorkflowRepository.VolatileState getVolatileState() {
        return this.volatileState;
    }
}

