/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.ext.wfrepo.classpath;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.copperengine.core.common.WorkflowRepository;
import org.copperengine.core.tranzient.TransientEngineFactory;
import org.copperengine.core.tranzient.TransientScottyEngine;
import org.copperengine.ext.wfrepo.classpath.ClasspathWorkflowRepository;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ClasspathWorkflowRepositoryTest {
    private static final String TESTWORKFLOWS_PACKAGE = "org.copperengine.ext.wfrepo.classpath.testworkflows";

    @Test
    public void testFindWorkflowClasses() throws Exception {
        Assume.assumeTrue((boolean)System.getProperty("jdk.module.path", "").isBlank());
        Set set = ClasspathWorkflowRepository.findWorkflowClasses(Collections.singletonList(TESTWORKFLOWS_PACKAGE), (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((long)5L, (long)set.size());
        Assert.assertNotNull((Object)set.contains(Class.forName("org.copperengine.ext.wfrepo.classpath.testworkflows.TestWorkflowThree")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExec() throws Exception {
        Assume.assumeTrue((boolean)System.getProperty("jdk.module.path", "").isBlank());
        final ClasspathWorkflowRepository wfRepo = new ClasspathWorkflowRepository(TESTWORKFLOWS_PACKAGE);
        try {
            TransientEngineFactory factory = new TransientEngineFactory(){

                protected WorkflowRepository createWorkflowRepository() {
                    return wfRepo;
                }

                protected File getWorkflowSourceDirectory() {
                    return null;
                }
            };
            TransientScottyEngine engine = factory.create();
            engine.run("org.copperengine.ext.wfrepo.classpath.testworkflows.TestWorkflowThree", (Object)"foo");
            Thread.sleep(1000L);
        }
        finally {
            wfRepo.shutdown();
        }
    }
}

