/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.ext.wfrepo.git;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.copperengine.core.CopperException;
import org.copperengine.core.DependencyInjector;
import org.copperengine.core.common.WorkflowRepository;
import org.copperengine.core.tranzient.TransientEngineFactory;
import org.copperengine.core.tranzient.TransientScottyEngine;
import org.copperengine.core.util.Backchannel;
import org.copperengine.core.util.BackchannelDefaultImpl;
import org.copperengine.core.util.PojoDependencyInjector;
import org.copperengine.ext.wfrepo.git.GitWorkflowRepository;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.RefNotAdvertisedException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitWorkflowRepositoryTest {
    public static final String WF_WORK = "wf-work";
    public static final String WORK_DIR = "./wf-work";
    public static final int CHECK_INTERVAL_M_SEC = 1000;
    private GitWorkflowRepository wfRepo;
    private TransientScottyEngine engine;
    private Backchannel channel;

    @Before
    public void setUp() throws Exception {
        FileUtils.deleteDirectory((File)new File(WORK_DIR));
        new File(WORK_DIR).mkdirs();
        GitWorkflowRepositoryTest.unzip(this.getClass().getClassLoader().getResource("git-wf.zip").openStream(), WORK_DIR);
        this.wfRepo = new GitWorkflowRepository();
        this.wfRepo.setGitRepositoryDir("./wf-work/wf-source");
        this.wfRepo.addSourceDir("./wf-work/wf-source");
        this.wfRepo.setTargetDir("./wf-work/wf-target");
        this.wfRepo.setOriginURI("file://" + new File("./wf-work/git-wf").getAbsolutePath());
        this.setUpEngine();
    }

    private void setUpEngine() {
        this.wfRepo.setCheckIntervalMSec(1000);
        final PojoDependencyInjector injector = new PojoDependencyInjector();
        TransientEngineFactory factory = new TransientEngineFactory(){

            protected WorkflowRepository createWorkflowRepository() {
                return GitWorkflowRepositoryTest.this.wfRepo;
            }

            protected File getWorkflowSourceDirectory() {
                return null;
            }

            protected DependencyInjector createDependencyInjector() {
                return injector;
            }
        };
        this.engine = factory.create();
        this.channel = new BackchannelDefaultImpl();
        injector.register("backChannel", (Object)this.channel);
    }

    @Test
    public void defaultBranchTest() throws Exception {
        this.engine.run("Workflow1", (Object)"foo");
        String result = (String)this.channel.wait("correlationId", 1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"Vmaster", (Object)result);
        Assert.assertEquals((Object)"master", (Object)this.wfRepo.getBranch());
    }

    @Test
    public void change2BranchesTest() throws CopperException, InterruptedException, IOException, GitAPIException {
        this.wfRepo.setBranch("1.0");
        LockSupport.parkNanos(2000000000L);
        this.engine.run("Workflow1", (Object)"foo");
        String result1 = (String)this.channel.wait("correlationId", 1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"V1.0", (Object)result1);
        this.wfRepo.setBranch("2.0");
        LockSupport.parkNanos(2000000000L);
        this.engine.run("Workflow1", (Object)"foo");
        String result2 = (String)this.channel.wait("correlationId", 1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"V2.0", (Object)result2);
    }

    @Test
    public void shutdownTest() {
        Assert.assertEquals((String)"wfRepos should be up.", (Object)true, (Object)this.wfRepo.isUp());
        this.wfRepo.shutdown();
        Assert.assertEquals((String)"wfRepos should be down.", (Object)false, (Object)this.wfRepo.isUp());
    }

    @Test(expected=IllegalStateException.class)
    public void shutdownStartTest() {
        Assert.assertEquals((String)"wfRepos should be up.", (Object)true, (Object)this.wfRepo.isUp());
        this.wfRepo.shutdown();
        Assert.assertEquals((String)"wfRepos should be down.", (Object)false, (Object)this.wfRepo.isUp());
        this.wfRepo.start();
    }

    @Test(expected=IllegalStateException.class)
    public void shutdownDoubleStartTest() {
        Assert.assertEquals((String)"wfRepos should be up.", (Object)true, (Object)this.wfRepo.isUp());
        this.wfRepo.start();
    }

    @Test(expected=RefNotAdvertisedException.class)
    public void changeToTagTest() throws IOException, GitAPIException {
        this.wfRepo.setBranch("2.0.0");
    }

    @Test
    public void sameGitRepositoryDirTest() throws Exception {
        this.wfRepo.setGitRepositoryDir("./wf-work/wf-source");
        this.defaultBranchTest();
    }

    @Test
    public void changeGitRepositoryRobustDirTest() throws Exception {
        this.wfRepo.setGitRepositoryDir("./wf-work/wf-source2");
        LockSupport.parkNanos(2000000000L);
        this.defaultBranchTest();
    }

    @Test
    public void sameGitRepositoryFakeCredentialTest() throws Exception {
        this.wfRepo.setCredentials("test", "s3cret".toCharArray());
        this.wfRepo.setGitRepositoryDir("./wf-work/wf-source");
        this.defaultBranchTest();
    }

    @Test
    public void changeGitRepositoryDirTest() throws Exception {
        this.wfRepo.setGitRepositoryDir("./wf-work/wf-source2");
        String oldSourceDir = (String)this.wfRepo.getSourceDirs().get(0);
        ArrayList<String> sourceDirs = new ArrayList<String>(1);
        sourceDirs.add(0, "./wf-work/wf-source2");
        this.wfRepo.setSourceDirs(sourceDirs);
        LockSupport.parkNanos(2000000000L);
        this.change2BranchesTest();
    }

    @Test
    public void changeGitRepositoryFailureDirTest() throws Exception {
        this.wfRepo.setGitRepositoryDir("./wf-work/wf-source2");
        LockSupport.parkNanos(2000000000L);
        this.defaultBranchTest();
        this.wfRepo.setBranch("1.0");
        LockSupport.parkNanos(2000000000L);
        this.engine.run("Workflow1", (Object)"foo");
        String result1 = (String)this.channel.wait("correlationId", 1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"new branch not loaded, so expect Vmaster", (Object)"Vmaster", (Object)result1);
    }

    @Test
    public void sameURITest() throws Exception {
        this.wfRepo.setOriginURI(this.wfRepo.getOriginUri());
        this.defaultBranchTest();
    }

    @Test(expected=InvalidRemoteException.class)
    public void changeURITest() throws Exception {
        this.wfRepo.setOriginURI(this.wfRepo.getOriginUri() + "ERROR_TEST");
        this.defaultBranchTest();
    }

    @Test(expected=GitWorkflowRepository.GitWorkflowRepositoryException.class)
    public void startFailureEmptyRepoTest() throws Exception {
        GitWorkflowRepository wfRepo2 = new GitWorkflowRepository();
        wfRepo2.start();
    }

    @Test(expected=GitWorkflowRepository.GitWorkflowRepositoryException.class)
    public void startFailureTargetDirTest() throws Exception {
        GitWorkflowRepository wfRepo2 = new GitWorkflowRepository();
        wfRepo2.setTargetDir("./wf-work/wf-target2");
        wfRepo2.start();
        Assert.assertEquals((String)"Repository should be down.", (Object)false, (Object)wfRepo2.isUp());
    }

    @After
    public void setDown() throws IOException {
        this.engine.shutdown();
        FileUtils.deleteDirectory((File)new File(WF_WORK));
    }

    private static void unzip(InputStream inputStream, String out) throws Exception {
        byte[] buffer = new byte[2048];
        Path outDir = Paths.get(out, new String[0]);
        try (BufferedInputStream bis = new BufferedInputStream(inputStream);
             ZipInputStream stream = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                Path filePath = outDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    filePath.toFile().mkdirs();
                    continue;
                }
                try (FileOutputStream fos = new FileOutputStream(filePath.toFile());
                     BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);){
                    int len;
                    while ((len = stream.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                }
            }
        }
    }
}

