/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.ext.wfrepo.git;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.copperengine.core.common.WorkflowRepository;
import org.copperengine.core.wfrepo.FileBasedWorkflowRepository;
import org.copperengine.management.FileBasedWorkflowRepositoryMXBean;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitWorkflowRepository
extends FileBasedWorkflowRepository
implements WorkflowRepository,
FileBasedWorkflowRepositoryMXBean {
    public static final String ORIGIN = "origin";
    public static final String DEFAULT_BRANCH = "master";
    private static final Logger logger = LoggerFactory.getLogger(GitWorkflowRepository.class);
    private String originUri;
    private String branch = "master";
    private File gitRepositoryDir;
    private CredentialsProvider credentialsProvider;
    private int checkIntervalMSecGit = 5000;
    private AtomicBoolean gitObserverStopped;
    private Thread observerThread;

    public synchronized void setGitRepositoryDir(File gitRepositoryDir) throws IOException, GitAPIException {
        if (this.isUp()) {
            this.deleteGitRepositoryDir();
        }
        this.gitRepositoryDir = gitRepositoryDir;
        if (this.isUp()) {
            this.updateLocalGitRepositories();
        }
    }

    public synchronized void setGitRepositoryDir(String gitRepositoryDir) throws IOException, GitAPIException {
        this.setGitRepositoryDir(new File(gitRepositoryDir));
    }

    public synchronized File getGitRepositoryDir() {
        return new File(this.gitRepositoryDir.getAbsolutePath());
    }

    public synchronized String getOriginUri() {
        return this.originUri;
    }

    public synchronized String getBranch() {
        return this.branch;
    }

    public synchronized void setOriginURI(String originUri) throws IOException, GitAPIException {
        this.originUri = originUri;
        if (this.isUp()) {
            this.deleteGitRepositoryDir();
            this.updateLocalGitRepositories();
        }
    }

    public synchronized void setCredentials(String username, char[] password) {
        this.credentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
    }

    public synchronized void setBranch(String branch) throws IOException, GitAPIException {
        this.branch = branch;
        if (this.isUp()) {
            this.updateLocalGitRepositories();
        }
    }

    public synchronized void setCheckIntervalMSec(int checkIntervalMSec) {
        this.checkIntervalMSecGit = checkIntervalMSec;
        super.setCheckIntervalMSec(checkIntervalMSec);
    }

    public synchronized void start() {
        logger.info("Starting git workflow repository.");
        if (this.gitObserverStopped != null) {
            throw new IllegalStateException("Git workflow repository can only be startet once.");
        }
        try {
            this.updateLocalGitRepositories();
        }
        catch (Exception e) {
            throw new GitWorkflowRepositoryException("Exception while initial update of it workflow repository.", e);
        }
        this.gitObserverStopped = new AtomicBoolean(false);
        this.observerThread = new ObserverThread(this);
        this.observerThread.start();
        super.start();
    }

    public synchronized void shutdown() {
        logger.info("Shutting down git workflow repository.");
        this.gitObserverStopped.set(true);
        this.observerThread.interrupt();
        try {
            this.observerThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.shutdown();
    }

    public synchronized boolean isUp() {
        return this.gitObserverStopped != null && !this.gitObserverStopped.get();
    }

    protected synchronized void updateLocalGitRepositories() throws IOException, GitAPIException {
        logger.debug("Update git repositories.");
        if (!this.getGitRepositoryDir().exists()) {
            logger.info("No local repository found. Clone a new one. Branch is {}.", (Object)this.branch);
            try (Git git = ((CloneCommand)Git.cloneRepository().setURI(this.originUri).setDirectory(this.getGitRepositoryDir()).setRemote(ORIGIN).setCredentialsProvider(this.credentialsProvider)).call();){
                git.checkout().setName("remotes/origin/" + this.branch).call();
            }
        }
        try (Git git = Git.open((File)this.getGitRepositoryDir());){
            Repository repository = git.getRepository();
            logger.debug("Local repository {} found. Checkout branch {} force.", (Object)repository, (Object)this.branch);
            logger.trace("Repository {}: bare={}.", (Object)repository, (Object)repository.isBare());
            git.checkout().setName("origin/" + this.branch).setForced(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
            logger.debug("Pull repository {}", (Object)repository);
            ((PullCommand)git.pull().setRemote(ORIGIN).setCredentialsProvider(this.credentialsProvider)).setRemoteBranchName(this.branch).call();
            logger.debug("Local repository {} found. Again checkout branch {} force.", (Object)repository, (Object)this.branch);
            git.checkout().setName("origin/" + this.branch).setForced(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
        }
    }

    protected synchronized void deleteGitRepositoryDir() throws IOException {
        logger.info("Delete repository dir {}.", (Object)this.getGitRepositoryDir());
        if (this.getGitRepositoryDir() != null) {
            FileUtils.deleteDirectory((File)this.getGitRepositoryDir());
        }
    }

    public static class GitWorkflowRepositoryException
    extends RuntimeException {
        public GitWorkflowRepositoryException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ObserverThread
    extends Thread {
        private static final Logger logger = LoggerFactory.getLogger(ObserverThread.class);
        private final WeakReference<GitWorkflowRepository> gitWorkflowRepository;

        private ObserverThread(GitWorkflowRepository repository) {
            super("WfRepoObserverGit");
            this.gitWorkflowRepository = new WeakReference<GitWorkflowRepository>(repository);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            logger.info("Starting git observation");
            GitWorkflowRepository repository = (GitWorkflowRepository)((Object)this.gitWorkflowRepository.get());
            while (repository != null && !repository.gitObserverStopped.get()) {
                try {
                    Thread.sleep(repository.checkIntervalMSecGit);
                    repository.updateLocalGitRepositories();
                }
                catch (Exception e) {
                    logger.info("Exception caught while git oberservation. Continue anyway.", (Throwable)e);
                }
            }
            logger.info("Stopping git observation");
        }
    }
}

