/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.spring;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.copperengine.management.AuditTrailMXBean;
import org.copperengine.management.AuditTrailQueryMXBean;
import org.copperengine.management.BatcherMXBean;
import org.copperengine.management.DatabaseDialectMXBean;
import org.copperengine.management.ProcessingEngineMXBean;
import org.copperengine.management.ProcessorPoolMXBean;
import org.copperengine.management.StatisticsCollectorMXBean;
import org.copperengine.management.WorkflowRepositoryMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JmxExporter
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(JmxExporter.class);
    private ApplicationContext applicationContext;
    private Set<ObjectName> objectNames = new HashSet<ObjectName>();
    private MBeanServer mBeanServer;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void startup() throws MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(WorkflowRepositoryMXBean.class), "copper.workflowrepo");
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(ProcessingEngineMXBean.class), "copper.engine");
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(ProcessorPoolMXBean.class), "copper.processorpool");
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(StatisticsCollectorMXBean.class), "copper.monitoring.statistics");
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(AuditTrailMXBean.class), "copper.db");
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(BatcherMXBean.class), "copper.db");
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(DatabaseDialectMXBean.class), "copper.db");
        this.register(this.mBeanServer, this.applicationContext.getBeansOfType(AuditTrailQueryMXBean.class), "copper.audittrail");
    }

    private void register(MBeanServer mBeanServer, Map<?, ?> map, String domain) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            ObjectName name = new ObjectName(domain, "name", entry.getKey().toString());
            mBeanServer.registerMBean(entry.getValue(), name);
            this.objectNames.add(name);
            logger.info("registered at JMX: " + name.toString());
        }
    }

    public void shutdown() throws MBeanRegistrationException, InstanceNotFoundException {
        for (ObjectName name : this.objectNames) {
            this.mBeanServer.unregisterMBean(name);
            logger.info("unregistered " + name);
        }
    }
}

