/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.spring;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

public abstract class SpringTransaction {
    protected abstract void execute(Connection var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PlatformTransactionManager transactionManager, DataSource dataSource, TransactionDefinition def) throws Exception {
        TransactionStatus txnStatus = transactionManager.getTransaction(def);
        try {
            Connection con = DataSourceUtils.getConnection((DataSource)dataSource);
            try {
                this.execute(con);
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
        }
        catch (Exception e) {
            transactionManager.rollback(txnStatus);
            throw e;
        }
        transactionManager.commit(txnStatus);
    }
}

