/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.spring.audit;

import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import org.copperengine.core.CopperRuntimeException;
import org.copperengine.core.audit.AbstractAuditTrail;
import org.copperengine.core.audit.AuditTrailEvent;
import org.copperengine.core.audit.BatchInsertIntoAutoTrail;
import org.copperengine.core.batcher.BatchCommand;
import org.copperengine.core.batcher.CommandCallback;
import org.copperengine.core.batcher.NullCallback;
import org.copperengine.spring.SpringTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTxnAuditTrail
extends AbstractAuditTrail {
    private static final Logger logger = LoggerFactory.getLogger(SpringTxnAuditTrail.class);
    private PlatformTransactionManager transactionManager;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void synchLog(final AuditTrailEvent e) {
        if (this.isEnabled(e.getLogLevel())) {
            logger.debug("doLog({})", (Object)e);
            e.setMessage(this.messagePostProcessor.serialize(e.getMessage()));
            try {
                new SpringTransaction(){

                    @Override
                    protected void execute(Connection con) throws Exception {
                        BatchInsertIntoAutoTrail.Command cmd = SpringTxnAuditTrail.this.createBatchCommand(e, true, (CommandCallback)NullCallback.instance);
                        List<BatchCommand> cmdList = Arrays.asList(cmd);
                        ((BatchInsertIntoAutoTrail.Executor)cmd.executor()).doExec(cmdList, con);
                    }
                }.run(this.transactionManager, this.getDataSource(), this.createTransactionDefinition());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CopperRuntimeException((Throwable)ex);
            }
        }
    }

    protected TransactionDefinition createTransactionDefinition() {
        return new DefaultTransactionDefinition();
    }
}

