/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.spring;

import java.sql.Connection;
import javax.sql.DataSource;
import org.copperengine.core.persistent.txn.DatabaseTransaction;
import org.copperengine.core.persistent.txn.Transaction;
import org.copperengine.core.persistent.txn.TransactionController;
import org.copperengine.spring.SpringTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransactionController
implements TransactionController {
    private static final Logger logger = LoggerFactory.getLogger(SpringTransactionController.class);
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public <T> T run(final DatabaseTransaction<T> txn) throws Exception {
        final Object[] t = new Object[1];
        new SpringTransaction(){

            @Override
            protected void execute(Connection con) throws Exception {
                t[0] = txn.run(con);
            }
        }.run(this.transactionManager, this.dataSource, (TransactionDefinition)new DefaultTransactionDefinition());
        return (T)t[0];
    }

    public <T> T run(Transaction<T> txn) throws Exception {
        TransactionStatus txnStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        Object t = null;
        try {
            t = txn.run();
        }
        catch (Exception e) {
            logger.error("execution failed - rolling back transaction", (Throwable)e);
            this.transactionManager.rollback(txnStatus);
            throw e;
        }
        this.transactionManager.commit(txnStatus);
        return (T)t;
    }
}

