/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.util.Objects;
import java.util.Optional;

public abstract class Annotated {
    private final String annotation_;
    private final String className_;
    private final boolean runtime_;
    private File file_;

    public static boolean isClass(Annotated annotated) {
        return annotated.getType() == Type.CLASS;
    }

    public static boolean isMethod(Annotated annotated) {
        return annotated.getType() == Type.METHOD;
    }

    public static boolean isField(Annotated annotated) {
        return annotated.getType() == Type.FIELD;
    }

    protected Annotated(String annotation, String className, boolean isRuntime, File file) {
        this.annotation_ = annotation;
        this.className_ = className;
        this.runtime_ = isRuntime;
        this.file_ = file;
    }

    public abstract Type getType();

    public String getAnnotation() {
        return this.annotation_;
    }

    public String getClassName() {
        return this.className_;
    }

    public boolean isRuntime() {
        return this.runtime_;
    }

    void setFile(File file) {
        this.file_ = file;
    }

    public File getFile() {
        return this.file_;
    }

    public int hashCode() {
        return Objects.hashCode(this.getClass()) ^ Objects.hashCode(this.getAnnotation()) ^ Objects.hashCode(this.getClassName()) ^ Objects.hashCode(this.isRuntime()) ^ Objects.hashCode(this.getFile());
    }

    public boolean equals(Object object) {
        return Optional.ofNullable(object).filter(other -> this.getClass().equals(other.getClass())).map(other -> (Annotated)other).map(other -> Objects.equals(other.getAnnotation(), this.getAnnotation()) && Objects.equals(other.getClassName(), this.getClassName()) && Objects.equals(other.isRuntime(), this.isRuntime()) && Objects.equals(other.getFile(), this.getFile())).orElse(false);
    }

    public static enum Type {
        CLASS,
        METHOD,
        FIELD;

    }
}

