/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.cornutum.annotation.Annotated;
import org.cornutum.annotation.ToString;

public class AnnotatedField
extends Annotated {
    private String field_;

    public AnnotatedField(String annotation, String className, String field, boolean isRuntime) {
        this(annotation, className, field, isRuntime, null);
    }

    public AnnotatedField(String annotation, String className, String field, boolean isRuntime, File file) {
        super(annotation, className, isRuntime, file);
        this.field_ = field;
    }

    public AnnotatedField(Class<? extends Annotation> annotation, String className, String field, boolean isRuntime, File file) {
        this((String)Optional.ofNullable(annotation).map(Class::getName).orElse(null), className, field, isRuntime, file);
    }

    @Override
    public Annotated.Type getType() {
        return Annotated.Type.FIELD;
    }

    public String getField() {
        return this.field_;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.getField());
    }

    @Override
    public boolean equals(Object object) {
        AnnotatedField other = super.equals(object) ? (AnnotatedField)object : null;
        return other != null && Objects.equals(other.getField(), this.getField());
    }

    public String toString() {
        return ToString.of(this).append(ToString.simpleClassName(this.getAnnotation())).append("class", this.getClassName()).append("field", this.getField()).append("runtime", this.isRuntime()).append("file", Optional.ofNullable(this.getFile()).map(File::getName).orElse(null)).toString();
    }
}

