/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.cornutum.annotation.Annotated;
import org.cornutum.annotation.ToString;

public class AnnotatedMethod
extends Annotated {
    private String method_;

    public AnnotatedMethod(String annotation, String className, String method, boolean isRuntime) {
        this(annotation, className, method, isRuntime, null);
    }

    public AnnotatedMethod(String annotation, String className, String method, boolean isRuntime, File file) {
        super(annotation, className, isRuntime, file);
        this.method_ = method;
    }

    public AnnotatedMethod(Class<? extends Annotation> annotation, String className, String method, boolean isRuntime, File file) {
        this((String)Optional.ofNullable(annotation).map(Class::getName).orElse(null), className, method, isRuntime, file);
    }

    @Override
    public Annotated.Type getType() {
        return Annotated.Type.METHOD;
    }

    public String getMethod() {
        return this.method_;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.getMethod());
    }

    @Override
    public boolean equals(Object object) {
        AnnotatedMethod other = super.equals(object) ? (AnnotatedMethod)object : null;
        return other != null && Objects.equals(other.getMethod(), this.getMethod());
    }

    public String toString() {
        return ToString.of(this).append(ToString.simpleClassName(this.getAnnotation())).append("class", this.getClassName()).append("method", this.getMethod()).append("runtime", this.isRuntime()).append("file", Optional.ofNullable(this.getFile()).map(File::getName).orElse(null)).toString();
    }
}

