/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.cornutum.annotation.AllAnnotated;
import org.cornutum.annotation.Annotated;
import org.cornutum.annotation.AnnotatedClass;
import org.cornutum.annotation.AnnotatedField;
import org.cornutum.annotation.AnnotatedMethod;
import org.cornutum.annotation.AnnotationFilter;
import org.cornutum.annotation.ToString;

public abstract class ClassData {
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_REF_FIELD = 9;
    private static final int CP_REF_METHOD = 10;
    private static final int CP_REF_INTERFACE = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final int CP_METHOD_HANDLE = 15;
    private static final int CP_METHOD_TYPE = 16;
    private static final int CP_INVOKE_DYNAMIC = 18;
    private static final int BYTE = 66;
    private static final int CHAR = 67;
    private static final int DOUBLE = 68;
    private static final int FLOAT = 70;
    private static final int INT = 73;
    private static final int LONG = 74;
    private static final int SHORT = 83;
    private static final int BOOLEAN = 90;
    private static final int STRING = 115;
    private static final int ENUM = 101;
    private static final int CLASS = 99;
    private static final int ANNOTATION = 64;
    private static final int ARRAY = 91;
    private Object[] constants_;
    private AnnotationContext context_ = new AnnotationContext();
    private List<Annotated> annotated_ = new ArrayList<Annotated>();
    private AnnotationFilter filter_;
    private static final Pattern RAW_TYPE_NAME_PATTERN = Pattern.compile("L([\\w/\\$]+);");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator<Annotated> getAnnotated(AnnotationFilter filter) {
        this.setFilter(filter);
        this.annotated_.clear();
        try (DataInputStream data = new DataInputStream(new BufferedInputStream(this.getInputStream(), 16384));){
            if (data.readInt() == -889275714) {
                this.readVersion(data);
                this.setConstants(this.readConstantPoolEntries(data));
                this.readAccessFlags(data);
                Optional.of(this.readThisClass(data)).filter(className -> this.getFilter().acceptClass((String)className)).ifPresent(className -> this.findAnnotations(data, (String)className));
            }
            Iterator<Annotated> iterator = this.annotated_.iterator();
            return iterator;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't read class data for %s", this), e);
        }
    }

    public static String rawTypeName(Class<?> type) {
        return ClassData.rawTypeName(type.getName());
    }

    public static String rawTypeName(String className) {
        return String.format("L%s;", className.replace('.', '/'));
    }

    public static String toClassName(String rawTypeName) {
        return Optional.of(RAW_TYPE_NAME_PATTERN.matcher(Optional.ofNullable(rawTypeName).orElse("null"))).filter(m -> m.matches()).map(m -> m.group(1).replace('/', '.')).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not a valid raw type name'", rawTypeName)));
    }

    public static String classPackage(String className) {
        return className.substring(0, className.lastIndexOf(46));
    }

    protected abstract InputStream getInputStream();

    private void findAnnotations(DataInput data, String className) {
        try {
            this.getContext().setClassName(className);
            this.readSuperClass(data);
            this.readInterfaces(data);
            this.readFields(data);
            this.readMethods(data);
            this.forType(Annotated.Type.CLASS, null, () -> this.readAttributes(data));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't find annotations for class=%s", className), e);
        }
    }

    private void readVersion(DataInput data) throws IOException {
        data.readUnsignedShort();
        data.readUnsignedShort();
    }

    private Object[] readConstantPoolEntries(DataInput data) throws IOException {
        int count = data.readUnsignedShort();
        Object[] constantPool = new Object[count];
        for (int i = 1; i < count; i += this.readConstantPoolEntry(data, constantPool, i)) {
        }
        return constantPool;
    }

    private int readConstantPoolEntry(DataInput data, Object[] constantPool, int index) throws IOException {
        int tag = data.readUnsignedByte();
        int numSlots = 1;
        switch (tag) {
            case 16: {
                data.skipBytes(2);
                break;
            }
            case 15: {
                data.skipBytes(3);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                data.skipBytes(4);
                break;
            }
            case 5: 
            case 6: {
                data.skipBytes(8);
                numSlots = 2;
                break;
            }
            case 1: {
                constantPool[index] = data.readUTF();
                break;
            }
            case 7: 
            case 8: {
                constantPool[index] = data.readUnsignedShort();
                break;
            }
            default: {
                throw new ClassFormatError("Unkown tag value for constant pool entry: " + tag);
            }
        }
        return numSlots;
    }

    private void readAccessFlags(DataInput data) throws IOException {
        data.skipBytes(2);
    }

    private String readThisClass(DataInput data) throws IOException {
        return this.resolveUtf8(data).replace('/', '.');
    }

    private void readSuperClass(DataInput data) throws IOException {
        data.skipBytes(2);
    }

    private void readInterfaces(DataInput data) throws IOException {
        int count = data.readUnsignedShort();
        data.skipBytes(count * 2);
    }

    private void readFields(DataInput data) throws IOException {
        int count = data.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(data);
            String fieldName = this.resolveUtf8(data);
            this.resolveUtf8(data);
            this.forType(Annotated.Type.FIELD, fieldName, () -> this.readAttributes(data));
        }
    }

    private void readMethods(DataInput data) throws IOException {
        int count = data.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(data);
            String methodName = this.resolveUtf8(data);
            this.resolveUtf8(data);
            this.forType(Annotated.Type.METHOD, methodName, () -> this.readAttributes(data));
        }
    }

    private void readAttributes(DataInput data) {
        try {
            int count = data.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                String name = this.resolveUtf8(data);
                int length = data.readInt();
                if ("RuntimeVisibleAnnotations".equals(name)) {
                    this.forRuntime(Boolean.TRUE, () -> this.readAnnotations(data));
                    continue;
                }
                if ("RuntimeInvisibleAnnotations".equals(name)) {
                    this.forRuntime(Boolean.FALSE, () -> this.readAnnotations(data));
                    continue;
                }
                data.skipBytes(length);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read attributes", e);
        }
    }

    private void readAnnotations(DataInput data) {
        try {
            int count = data.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                this.reportAnnotation(this.readAnnotation(data));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read annotations", e);
        }
    }

    private String readAnnotation(DataInput data) throws IOException {
        String rawTypeName = this.resolveUtf8(data);
        int count = data.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.resolveUtf8(data);
            this.readAnnotationElementValue(data);
        }
        return rawTypeName;
    }

    private void readAnnotationElementValue(DataInput data) throws IOException {
        int tag = data.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                data.skipBytes(2);
                break;
            }
            case 101: {
                data.skipBytes(4);
                break;
            }
            case 99: {
                data.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(data);
                break;
            }
            case 91: {
                int count = data.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    this.readAnnotationElementValue(data);
                }
                break;
            }
            default: {
                throw new ClassFormatError("Not a valid annotation element type tag: 0x" + Integer.toHexString(tag));
            }
        }
    }

    private String resolveUtf8(DataInput data) throws IOException {
        Object value = this.getConstant(data.readUnsignedShort());
        return value.getClass().equals(String.class) ? (String)value : (String)this.getConstant((Integer)value);
    }

    private void setFilter(AnnotationFilter filter) {
        this.filter_ = Optional.ofNullable(filter).orElse(AllAnnotated.INSTANCE);
    }

    private AnnotationFilter getFilter() {
        return this.filter_;
    }

    private AnnotationContext getContext() {
        return this.context_;
    }

    private void forType(Annotated.Type type, String elementName, Runnable step) {
        AnnotationContext context = this.getContext();
        try {
            context.setType(type);
            context.setElement(elementName);
            step.run();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't read attributes for type=%s", new Object[]{type}), e);
        }
        finally {
            context.setType(null);
            context.setElement(null);
        }
    }

    private void forRuntime(Boolean isRuntime, Runnable step) {
        AnnotationContext context = this.getContext();
        try {
            context.setRuntime(isRuntime);
            step.run();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't read annotations for runtime=%s", isRuntime), e);
        }
        finally {
            context.setRuntime(null);
        }
    }

    private void reportAnnotation(String rawTypeName) {
        this.getFilter().acceptAnnotation(rawTypeName).ifPresent(annotation -> {
            AnnotationContext context = this.getContext();
            context.setAnnotation((String)annotation);
            this.annotated_.add(context.getAnnotated());
            context.setAnnotation(null);
        });
    }

    private void setConstants(Object[] constants) {
        this.constants_ = constants;
    }

    private Object getConstant(int i) {
        return this.constants_[i];
    }

    private static class AnnotationContext {
        private String annotation_;
        private Annotated.Type type_;
        private String className_;
        private String elementName_;
        private Boolean runtime_;

        private AnnotationContext() {
        }

        public void setAnnotation(String annotation) {
            this.annotation_ = annotation;
        }

        public String getAnnotation() {
            return this.annotation_;
        }

        public void setClassName(String className) {
            this.className_ = className;
        }

        public String getClassName() {
            return this.className_;
        }

        public void setType(Annotated.Type type) {
            this.type_ = type;
        }

        public Annotated.Type getType() {
            return this.type_;
        }

        public void setElement(String element) {
            this.elementName_ = element;
        }

        public String getElement() {
            return this.elementName_;
        }

        public void setRuntime(Boolean runtime) {
            this.runtime_ = runtime;
        }

        public Boolean isRuntime() {
            return this.runtime_;
        }

        public Annotated getAnnotated() {
            String annotation = Optional.ofNullable(this.getAnnotation()).orElseThrow(() -> new IllegalStateException("Annotation type undefined for this annotated element"));
            String className = Optional.ofNullable(this.getClassName()).orElseThrow(() -> new IllegalStateException("Class undefined for this annotated element"));
            boolean isRuntime = Optional.ofNullable(this.isRuntime()).orElseThrow(() -> new IllegalStateException("Runtime availability undefined for this annotation"));
            Annotated annotated = null;
            switch (this.getType()) {
                case CLASS: {
                    annotated = new AnnotatedClass(annotation, className, isRuntime);
                    break;
                }
                case METHOD: {
                    annotated = new AnnotatedMethod(annotation, className, Optional.ofNullable(this.getElement()).orElseThrow(() -> new IllegalStateException("Method undefined for this annotated element")), isRuntime);
                    break;
                }
                case FIELD: {
                    annotated = new AnnotatedField(annotation, className, Optional.ofNullable(this.getElement()).orElseThrow(() -> new IllegalStateException("Field undefined for this annotated element")), isRuntime);
                }
            }
            return annotated;
        }

        public String toString() {
            return ToString.of(this).append("annotation", ToString.simpleClassName(this.getAnnotation())).append("class", this.getClassName()).append("type", (Object)this.getType()).append("element", this.getElement()).append("runtime", this.isRuntime()).toString();
        }
    }
}

