/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.cornutum.annotation.Annotated;
import org.cornutum.annotation.AnnotationFilter;
import org.cornutum.annotation.ClassFileData;
import org.cornutum.annotation.DirectoryAnnotated;
import org.cornutum.annotation.FlatMapIterator;
import org.cornutum.annotation.JarAnnotated;

public class ClassPathAnnotated
extends FlatMapIterator<Annotated, File> {
    private AnnotationFilter filter_;

    public ClassPathAnnotated(Collection<File> classPath, AnnotationFilter filter) {
        super(classPath);
        this.filter_ = filter;
    }

    @Override
    protected Iterator<Annotated> map(File file) {
        return file.isDirectory() ? new DirectoryAnnotated(file, this.filter_) : (file.getName().endsWith(".jar") ? new JarAnnotated(file, this.filter_) : new ClassFileData(file).getAnnotated(this.filter_));
    }

    @Override
    protected boolean accept(File file) {
        return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".class");
    }
}

