/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.util.Iterator;
import org.cornutum.annotation.Annotated;
import org.cornutum.annotation.AnnotationFilter;
import org.cornutum.annotation.ClassFileData;
import org.cornutum.annotation.Files;
import org.cornutum.annotation.FlatMapIterator;
import org.cornutum.annotation.ToString;

public class DirectoryAnnotated
extends FlatMapIterator<Annotated, File> {
    private final File dir_;
    private final AnnotationFilter filter_;

    public DirectoryAnnotated(File dir, AnnotationFilter filter) {
        super(Files.classFiles(dir));
        this.dir_ = dir;
        this.filter_ = filter;
    }

    public File getDir() {
        return this.dir_;
    }

    @Override
    protected Iterator<Annotated> map(File file) {
        return new ClassFileData(file).getAnnotated(this.filter_);
    }

    public String toString() {
        return ToString.of(this).append(this.getDir()).toString();
    }
}

