/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class Files {
    private Files() {
    }

    public static Collection<File> allFiles(File dir) {
        return Files.addMembers(new ArrayList<File>(), dir.isDirectory() ? dir.listFiles() : new File[]{});
    }

    public static Collection<File> allDirs(File dir) {
        return Files.addSubdirs(new ArrayList<File>(), dir.isDirectory() ? dir.listFiles() : new File[]{});
    }

    public static Collection<File> classFiles(File dir) {
        return Files.allFiles(dir).stream().filter(file -> !file.isDirectory() && file.getName().endsWith(".class")).collect(Collectors.toList());
    }

    private static Collection<File> addMembers(Collection<File> files, File[] members) {
        for (File member : members) {
            if (member.isDirectory()) {
                Files.addMembers(files, member.listFiles());
                continue;
            }
            files.add(member);
        }
        return files;
    }

    private static Collection<File> addSubdirs(Collection<File> files, File[] members) {
        for (File member : members) {
            if (!member.isDirectory()) continue;
            files.add(member);
            Files.addSubdirs(files, member.listFiles());
        }
        return files;
    }

    public static Set<File> classPathFor(String ... packageNames) {
        return Files.classPathFor(Arrays.asList(packageNames));
    }

    public static Set<File> classPathFor(ClassLoader loader, String ... packageNames) {
        return Files.classPathFor(loader, Arrays.asList(packageNames));
    }

    public static Set<File> classPathFor(Collection<String> packageNames) {
        return Files.classPathFor(Thread.currentThread().getContextClassLoader(), packageNames);
    }

    public static Set<File> classPathFor(ClassLoader loader, Collection<String> packageNames) {
        return packageNames.stream().flatMap(packageName -> {
            try {
                return Collections.list(loader.getResources(Arrays.asList(packageName.split("\\.")).stream().collect(Collectors.joining("/", "", "/")))).stream();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Can't get resources for package=%s", packageName), e);
            }
        }).map(url -> {
            Optional<File> classPathFile = "file".equals(url.getProtocol()) ? Files.toClassFile(url) : ("jar".equals(url.getProtocol()) ? Files.toJarFile(url) : Optional.empty());
            return classPathFile;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Optional<File> toClassFile(URL url) {
        try {
            return Optional.of(Files.toFile(url)).filter(file -> file.isDirectory() || file.getPath().endsWith(".class"));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't get file from url=%s", url), e);
        }
    }

    public static Optional<File> toJarFile(URL url) {
        try {
            JarURLConnection jar = (JarURLConnection)url.openConnection();
            return Optional.of(jar.getJarFileURL()).filter(jarUrl -> "file".equals(jarUrl.getProtocol())).map(jarUrl -> Files.toFile(jarUrl));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't get JAR file from url=%s", url), e);
        }
    }

    public static File toFile(URL url) {
        try {
            return new File(url.toURI().getPath());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't get file from url=%s", url), e);
        }
    }
}

