/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.annotation.AllAnnotated;
import org.cornutum.annotation.Annotated;
import org.cornutum.annotation.AnnotationFilter;
import org.cornutum.annotation.ClassPathAnnotated;
import org.cornutum.annotation.Iterators;

public class Finder {
    private AnnotationFilter filter_;
    private Set<File> classPath_ = new LinkedHashSet<File>();

    public Finder() {
        this(null);
    }

    public Finder(AnnotationFilter filter) {
        this.filter(filter);
    }

    public Finder inSystemClassPath() {
        return this.inClasses(Arrays.stream(System.getProperty("java.class.path").split(System.getProperty("path.separator"))).map(File::new).collect(Collectors.toList()));
    }

    public Finder filter(AnnotationFilter filter) {
        this.filter_ = Optional.ofNullable(filter).orElse(AllAnnotated.INSTANCE);
        return this;
    }

    public Finder inClasses(File ... classPath) {
        return this.inClasses(Arrays.asList(classPath));
    }

    public Finder inClasses(Collection<File> classPath) {
        this.classPath_.addAll(classPath);
        return this;
    }

    public Stream<Annotated> find() {
        return Iterators.toStream(new ClassPathAnnotated(this.classPath_, this.filter_));
    }
}

