/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;

public abstract class FlatMapIterator<T, E>
implements Iterator<T> {
    private Iterator<E> elements_;
    private Optional<Iterator<T>> nextMapping_;

    public FlatMapIterator(Collection<E> elements) {
        this.elements_ = Optional.ofNullable(elements).map(Collection::iterator).orElse(Collections.emptyIterator());
    }

    protected abstract Iterator<T> map(E var1);

    protected boolean accept(E element) {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.nextMapping().map(Iterator::hasNext).orElse(false);
    }

    @Override
    public T next() {
        return (T)this.nextMapping().map(Iterator::next).orElseThrow(() -> new NoSuchElementException());
    }

    private Optional<Iterator<T>> nextMapping() {
        Optional<Iterator<Iterator<T>>> optional = this.nextMapping_ = this.nextMapping_ == null ? this.findNextMapping() : this.nextMapping_;
        while (this.nextMapping_.map(i -> !i.hasNext()).orElse(false).booleanValue()) {
            this.nextMapping_ = this.findNextMapping();
        }
        return this.nextMapping_;
    }

    private Optional<Iterator<T>> findNextMapping() {
        Object nextElement = null;
        while (this.elements_.hasNext()) {
            E e2 = this.elements_.next();
            nextElement = e2;
            if (this.accept(e2)) break;
            nextElement = null;
        }
        return Optional.ofNullable(nextElement).map(e -> this.map(e));
    }
}

