/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Iterators {
    private Iterators() {
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        return Optional.ofNullable(iterator).map(i -> {
            Iterable iterable = () -> i;
            return Iterators.toStream(iterable);
        }).orElse(null);
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return Optional.ofNullable(iterable).map(i -> StreamSupport.stream(i.spliterator(), false)).orElse(null);
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        return Iterators.toStream(iterator).collect(Collectors.toList());
    }
}

