/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.annotation;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.cornutum.annotation.Annotated;
import org.cornutum.annotation.AnnotationFilter;
import org.cornutum.annotation.ClassEntryData;
import org.cornutum.annotation.FlatMapIterator;
import org.cornutum.annotation.JarEntryReader;
import org.cornutum.annotation.ToString;

public class JarAnnotated
extends FlatMapIterator<Annotated, JarEntryReader> {
    private final File jar_;
    private final AnnotationFilter filter_;

    public JarAnnotated(File jar, AnnotationFilter filter) {
        super(JarAnnotated.entryReaders(jar));
        this.jar_ = jar;
        this.filter_ = filter;
    }

    public File getJar() {
        return this.jar_;
    }

    @Override
    protected boolean accept(JarEntryReader reader) {
        return this.filter_.acceptClass(JarAnnotated.entryClass(reader.getEntry().getName()));
    }

    @Override
    protected Iterator<Annotated> map(JarEntryReader reader) {
        return new ClassEntryData(reader).getAnnotated(this.filter_);
    }

    private static String entryClass(String classEntryName) {
        return classEntryName.substring(0, classEntryName.lastIndexOf(".class")).replace('/', '.');
    }

    private static Collection<JarEntryReader> entryReaders(File jar) {
        try {
            JarFile jarFile = new JarFile(jar);
            return Collections.list(jarFile.entries()).stream().filter(entry -> entry.getName().endsWith(".class")).map((? super T entry) -> new JarEntryReader(jarFile, (JarEntry)entry)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't read entries for jar=%s", jar), e);
        }
    }

    public String toString() {
        return ToString.of(this).append(this.getJar().getName()).toString();
    }
}

